/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.ProcessDaemonRequirement;
import org.echocat.jomon.process.listeners.startup.StartupListener;
import org.echocat.jomon.process.listeners.stream.StreamListener;
import org.echocat.jomon.runtime.io.StreamType;
import org.echocat.jomon.runtime.util.ByteCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputMonitor<E, ID, P extends GeneratedProcess<E, ID>, R extends ProcessDaemonRequirement<E, ID, P, ?>>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(OutputMonitor.class);
    @Nonnull
    private final P _process;
    @Nonnull
    private final R _requirement;
    @Nonnull
    private final InputStream _stream;
    @Nonnull
    private final StreamType _streamType;
    @Nonnull
    private final ByteCount _sizeOfReadBuffer;

    public OutputMonitor(@Nonnull R requirement, @Nonnull P process, @Nonnull InputStream stream, @Nonnull StreamType streamType, @Nonnull ByteCount sizeOfReadBuffer) {
        this._requirement = requirement;
        this._process = process;
        this._stream = stream;
        this._streamType = streamType;
        this._sizeOfReadBuffer = sizeOfReadBuffer;
    }

    @Override
    public void run() {
        block4: {
            StreamListener<P> streamListener = this._requirement.getStreamListener();
            StartupListener<P> startupListener = this._requirement.getStartupListener();
            try {
                byte[] buffer = this._sizeOfReadBuffer.allocate();
                int read = this._stream.read(buffer);
                while (read >= 0) {
                    startupListener.notifyOutput(this._process, buffer, 0, read, this._streamType);
                    streamListener.notifyOutput(this._process, buffer, 0, read, this._streamType);
                    read = this._stream.read(buffer);
                }
            }
            catch (InterruptedIOException ignored) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                if (e instanceof IOException && "Stream closed".equals(e.getMessage())) break block4;
                LOG.warn("Could not read from " + this._stream + ".", (Throwable)e);
            }
        }
    }
}

