/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon;

import com.google.common.base.Predicate;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.ProcessDaemon;
import org.echocat.jomon.process.listeners.startup.StartupListenerBasedRequirement;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.numbers.IntegerRange;

public interface ProcessDaemonRequirement<E, ID, P extends GeneratedProcess<E, ID>, T extends ProcessDaemon<E, ID, P, ?, ?>>
extends StartupListenerBasedRequirement<E, ID, P> {
    public static final Predicate<Integer> DEFAULT_EXIT_CODE_VALIDATOR = new Predicate<Integer>(){

        public boolean apply(@Nullable Integer input) {
            return input != null && input == 0;
        }
    };

    @Nonnull
    public Class<T> getType();

    @Nonnull
    public Predicate<Integer> getExitCodeValidator();

    public static abstract class Base<E, ID, P extends GeneratedProcess<E, ID>, T extends ProcessDaemon<E, ID, P, ?, ?>, B extends Base<E, ID, P, T, B>>
    extends StartupListenerBasedRequirement.Base<E, ID, P, B>
    implements ProcessDaemonRequirement<E, ID, P, T> {
        @Nonnull
        private final Class<T> _type;
        @Nonnull
        private Predicate<Integer> _exitCodeValidator = DEFAULT_EXIT_CODE_VALIDATOR;

        public Base(@Nonnull Class<T> type) {
            this._type = type;
        }

        @Override
        @Nonnull
        public Class<T> getType() {
            return this._type;
        }

        @Nonnull
        public B withExitCodeValidator(@Nonnull Predicate<Integer> validator) {
            this._exitCodeValidator = validator;
            return (B)((Base)this.thisObject());
        }

        @Nonnull
        public B withExitCodeValidatorThatMatches(@Nullable Integer exitCode) {
            return this.withExitCodeValidatorThatMatches(CollectionUtils.asSet((Object[])new Integer[]{exitCode}));
        }

        @Nonnull
        public B withExitCodeValidatorThatMatches(Integer ... exitCodes) {
            return this.withExitCodeValidatorThatMatches(CollectionUtils.asSet((Object[])exitCodes));
        }

        @Nonnull
        public B withExitCodeValidatorThatMatches(@Nullable Iterable<Integer> exitCodes) {
            final Set potentials = CollectionUtils.asSet(exitCodes);
            return this.withExitCodeValidator(new Predicate<Integer>(){

                public boolean apply(@Nullable Integer input) {
                    return potentials.contains(input);
                }
            });
        }

        @Nonnull
        public B withExitCodeValidatorThatMatchesBetween(@Nullable @Including Integer from, @Nullable @Excluding Integer to) {
            return this.withExitCodeValidator((Predicate<Integer>)new IntegerRange(from, to));
        }

        @Override
        @Nonnull
        public Predicate<Integer> getExitCodeValidator() {
            return this._exitCodeValidator;
        }
    }
}

