/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon;

import javax.annotation.Nonnull;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.ProcessDaemonRequirement;

public class ProcessMonitor<E, ID, P extends GeneratedProcess<E, ID>, R extends ProcessDaemonRequirement<E, ID, P, ?>>
implements Runnable {
    @Nonnull
    private final R _requirement;
    @Nonnull
    private final P _process;

    public ProcessMonitor(@Nonnull R requirement, @Nonnull P process) {
        this._requirement = requirement;
        this._process = process;
    }

    @Override
    public void run() {
        boolean gotInterrupted = false;
        boolean regularEnd = false;
        do {
            try {
                boolean success = this._requirement.getExitCodeValidator().apply((Object)this._process.waitFor());
                this._requirement.getStartupListener().notifyProcessTerminated(this._process, success);
                this._requirement.getStreamListener().notifyProcessTerminated(this._process, success);
                regularEnd = true;
            }
            catch (InterruptedException ignored) {
                gotInterrupted = true;
            }
        } while (!regularEnd);
        if (gotInterrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

