/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.listeners.startup;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.CouldNotStartException;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.listeners.startup.StartupListener;
import org.echocat.jomon.process.listeners.stream.LineBasedStreamListenerSupport;
import org.echocat.jomon.runtime.io.StreamType;
import org.echocat.jomon.runtime.util.ByteCount;
import org.echocat.jomon.runtime.util.Duration;

public abstract class LineBasedStartupListenerSupport<P extends GeneratedProcess<?, ?>, L extends LineBasedStartupListenerSupport<P, L>>
extends LineBasedStreamListenerSupport<P, L>
implements StartupListener<P> {
    @Nonnull
    private final ByteBuffer _recordedContentWhileWaiting = ByteCount.allocateBuffer((String)"5m");
    @Nonnull
    private Duration _maxWaitTimeForStartupOfApplication = new Duration("1m");
    private volatile Boolean _startupDone;

    @Override
    public boolean waitForSuccessfulStart() throws InterruptedException {
        while (!Thread.currentThread().isInterrupted() && this._startupDone == null) {
            this.lock().lockInterruptibly();
            try {
                if (this.condition().await(this._maxWaitTimeForStartupOfApplication.in(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)) continue;
                this._startupDone = false;
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock().unlock();
            }
        }
        return this._startupDone;
    }

    @Override
    public void notifyProcessTerminated(@Nonnull P process, boolean regular) {
        this.lock().lock();
        try {
            super.notifyProcessTerminated(process, regular);
            if (this._startupDone == null) {
                this._startupDone = regular;
                this.condition().signalAll();
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    @Override
    public Boolean isSuccessfulStarted() {
        return this._startupDone;
    }

    @Override
    @Nullable
    public ByteBuffer getRecordedContentWhileWaiting() {
        this.lock().lock();
        try {
            if (this._startupDone == null) {
                throw new IllegalStateException("The startup is still in process.");
            }
            ByteBuffer byteBuffer = this._recordedContentWhileWaiting;
            return byteBuffer;
        }
        finally {
            this.lock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getRecordedContentWhileWaitingAsString() {
        this.lock().lock();
        try {
            String string;
            if (this._startupDone == null) {
                throw new IllegalStateException("The startup is still in process.");
            }
            int limit = this._recordedContentWhileWaiting.limit();
            int position = this._recordedContentWhileWaiting.position();
            this._recordedContentWhileWaiting.flip();
            try {
                string = this.getCharset().decode(this._recordedContentWhileWaiting).toString();
                this._recordedContentWhileWaiting.limit(limit);
            }
            catch (Throwable throwable) {
                this._recordedContentWhileWaiting.limit(limit);
                this._recordedContentWhileWaiting.position(position);
                throw throwable;
            }
            this._recordedContentWhileWaiting.position(position);
            return string;
        }
        finally {
            this.lock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOutput(@Nonnull P process, @Nonnull byte[] data, @Nonnegative int offset, @Nonnegative int length, @Nonnull StreamType streamType) {
        if (this._startupDone == null) {
            this.lock().lock();
            try {
                this._recordedContentWhileWaiting.put(data, offset, length);
                super.notifyOutput(process, data, offset, length, streamType);
            }
            finally {
                this.lock().unlock();
            }
        }
    }

    @Override
    @Nullable
    public Throwable getStartupProblem() {
        this.lock().lock();
        try {
            if (this._startupDone == null) {
                throw new IllegalStateException("The startup is still in process.");
            }
            CouldNotStartException result = this._startupDone == false ? new CouldNotStartException("Could not start process. Contents while starting:\n" + this.getRecordedContentWhileWaitingAsString()) : null;
            CouldNotStartException couldNotStartException = result;
            return couldNotStartException;
        }
        finally {
            this.lock().unlock();
        }
    }

    @Override
    protected void write(@Nonnull P process, @Nonnull String content, @Nonnull StreamType streamType) {
        this.notifyOutputWhileStartup(process, content, streamType);
    }

    protected void notifyOutputWhileStartup(@Nonnull P process, @Nonnull String line, @Nonnull StreamType streamType) {
    }

    protected void notifyProcessStartupDone(@Nonnull P process, @Nonnull boolean success) {
        this.lock().lock();
        try {
            if (this._startupDone == null) {
                this._startupDone = success;
                this.condition().signalAll();
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    @Nonnull
    public L whichWaitsForTheStartupUntil(@Nonnull Duration duration) {
        this.setMaxWaitTimeForStartupOfApplication(duration);
        return (L)((LineBasedStartupListenerSupport)this.thisObject());
    }

    @Nonnull
    public L whichWaitsForTheStartupUntil(@Nonnegative long duration) {
        return this.whichWaitsForTheStartupUntil(new Duration(duration));
    }

    @Nonnull
    public L whichWaitsForTheStartupUntil(@Nonnull String duration) {
        return this.whichWaitsForTheStartupUntil(new Duration(duration));
    }

    @Nonnull
    public Duration getMaxWaitTimeForStartupOfApplication() {
        return this._maxWaitTimeForStartupOfApplication;
    }

    public void setMaxWaitTimeForStartupOfApplication(Duration maxWaitTimeForStartupOfApplication) {
        this._maxWaitTimeForStartupOfApplication = maxWaitTimeForStartupOfApplication != null ? maxWaitTimeForStartupOfApplication : new Duration("1m");
    }
}

