/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.listeners.startup;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.listeners.startup.LineBasedStartupListenerSupport;
import org.echocat.jomon.runtime.io.StreamType;

public class WaitForContentInLineStartupListener<P extends GeneratedProcess<?, ?>>
extends LineBasedStartupListenerSupport<P, WaitForContentInLineStartupListener<P>> {
    @Nonnull
    private final Pattern _successLinePattern;
    @Nullable
    private Pattern _failLinePattern;

    @Nonnull
    public static <P extends GeneratedProcess<?, ?>> WaitForContentInLineStartupListener<P> waitForContentInLine(@Nonnull Pattern successLinePattern) {
        return new WaitForContentInLineStartupListener<P>(successLinePattern);
    }

    @Nonnull
    public static <P extends GeneratedProcess<?, ?>> WaitForContentInLineStartupListener<P> waitForContentInLine(@Nonnull String successLinePattern) {
        return WaitForContentInLineStartupListener.waitForContentInLine(Pattern.compile(successLinePattern, 32));
    }

    public WaitForContentInLineStartupListener(@Nonnull Pattern successLinePattern) {
        this._successLinePattern = successLinePattern;
    }

    @Nonnull
    public WaitForContentInLineStartupListener<P> whichFailsOnLineWith(@Nonnull Pattern pattern) {
        this._failLinePattern = pattern;
        return (WaitForContentInLineStartupListener)this.thisObject();
    }

    @Nonnull
    public WaitForContentInLineStartupListener<P> whichFailsOnLineWith(@Nonnull String pattern) {
        return this.whichFailsOnLineWith(Pattern.compile(pattern));
    }

    @Nonnull
    public Pattern getSuccessLinePattern() {
        return this._successLinePattern;
    }

    @Nullable
    public Pattern getFailLinePattern() {
        return this._failLinePattern;
    }

    public void setFailLinePattern(Pattern failLinePattern) {
        this._failLinePattern = failLinePattern;
    }

    @Override
    protected void notifyOutputWhileStartup(@Nonnull P process, @Nonnull String line, @Nonnull StreamType streamType) {
        if (this._successLinePattern.matcher(line).matches()) {
            this.notifyProcessStartupDone(process, true);
        } else {
            Pattern failLinePattern = this._failLinePattern;
            if (failLinePattern != null && failLinePattern.matcher(line).matches()) {
                this.notifyProcessStartupDone(process, false);
            }
        }
    }
}

