/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.listeners.stream;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.listeners.stream.LineBasedStreamListenerSupport;
import org.echocat.jomon.runtime.io.StreamType;

public abstract class LineBasedAndStateEnabledStreamListenerSupport<P extends GeneratedProcess<?, ?>, T extends LineBasedAndStateEnabledStreamListenerSupport<P, T>>
extends LineBasedStreamListenerSupport<P, T> {
    private boolean _started;
    private boolean _terminated;
    private boolean _startupDone;
    private boolean _recordProcessStarted;
    private boolean _recordProcessTerminated;
    private boolean _recordProcessStartupSuccessful;

    @Override
    public void notifyProcessStarted(@Nonnull P process) {
        this.lock().lock();
        try {
            if (!this._started) {
                if (this._recordProcessStarted) {
                    this.formatAndWrite(process, process + " started.", StreamType.system);
                }
                this._started = true;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    @Override
    public void notifyProcessStartupDone(@Nonnull P process) {
        this.lock().lock();
        try {
            if (!this._startupDone) {
                if (this._recordProcessStartupSuccessful) {
                    this.formatAndWrite(process, process + " startup done.", StreamType.system);
                }
                this._startupDone = true;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyProcessTerminated(@Nonnull P process, boolean regular) {
        this.lock().lock();
        try {
            if (!this._terminated) {
                if (this._recordProcessTerminated) {
                    Integer exitCode = this.getExitCode(process);
                    this.formatAndWrite(process, process + " ended " + (regular ? "regular" : "irregular") + "." + (exitCode != null ? " ExitCode: " + exitCode : ""), regular ? StreamType.system : StreamType.stderr);
                }
                this._terminated = true;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    @Nullable
    protected Integer getExitCode(P process) {
        Integer result;
        try {
            result = process.exitValue();
        }
        catch (IllegalStateException ignored) {
            result = null;
        }
        return result;
    }

    @Nonnull
    public T whichRecordsProcessStart(boolean record) {
        this._recordProcessStarted = record;
        return (T)((LineBasedAndStateEnabledStreamListenerSupport)this.thisObject());
    }

    @Nonnull
    public T whichRecordsProcessStart() {
        return this.whichRecordsProcessStart(true);
    }

    @Nonnull
    public T whichNotRecordsProcessStart() {
        return this.whichRecordsProcessStart(false);
    }

    @Nonnull
    public T whichRecordsProcessTermination(boolean record) {
        this._recordProcessTerminated = record;
        return (T)((LineBasedAndStateEnabledStreamListenerSupport)this.thisObject());
    }

    @Nonnull
    public T whichRecordsProcessTermination() {
        return this.whichRecordsProcessTermination(true);
    }

    @Nonnull
    public T whichNotRecordsProcessTermination() {
        return this.whichRecordsProcessTermination(false);
    }

    @Nonnull
    public T whichRecordsProcessStartupSuccessful(boolean record) {
        this._recordProcessStartupSuccessful = record;
        return (T)((LineBasedAndStateEnabledStreamListenerSupport)this.thisObject());
    }

    @Nonnull
    public T whichRecordsProcessStartupSuccessful() {
        return this.whichRecordsProcessStartupSuccessful(true);
    }

    @Nonnull
    public T whichNotRecordsProcessStartupSuccessful() {
        return this.whichRecordsProcessStartupSuccessful(false);
    }

    public boolean isRecordProcessStarted() {
        return this._recordProcessStarted;
    }

    public boolean isRecordProcessTerminated() {
        return this._recordProcessTerminated;
    }

    public boolean isRecordProcessStartupSuccessful() {
        return this._recordProcessStartupSuccessful;
    }
}

