/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.local;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.jomon.process.local.LocalProcess;

public class LocalGeneratedProcessImpl
implements LocalGeneratedProcess {
    private final LocalProcess _placeHolder;
    private final Process _original;
    private final boolean _isDaemon;

    public LocalGeneratedProcessImpl(@Nonnull LocalProcess placeHolder, @Nonnull Process original, boolean isDaemon) {
        this._placeHolder = placeHolder;
        this._original = original;
        this._isDaemon = isDaemon;
    }

    public Long getId() {
        return (Long)this._placeHolder.getId();
    }

    @Override
    @Nullable
    public File getExecutable() {
        return (File)this._placeHolder.getExecutable();
    }

    @Override
    @Nullable
    public List<String> getArguments() {
        return this._placeHolder.getArguments();
    }

    @Override
    @Nonnull
    public OutputStream getStdin() {
        return this._original.getOutputStream();
    }

    @Override
    @Nonnull
    public InputStream getStdout() {
        return this._original.getInputStream();
    }

    @Override
    @Nonnull
    public InputStream getStderr() {
        return this._original.getErrorStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this._original.waitFor();
    }

    @Override
    public int exitValue() {
        try {
            return this._original.exitValue();
        }
        catch (IllegalThreadStateException e) {
            throw new IllegalStateException("Process is still running.", e);
        }
    }

    @Override
    public boolean isAlive() {
        boolean result;
        try {
            result = this._original.exitValue() >= 0;
        }
        catch (IllegalThreadStateException ignored) {
            result = false;
        }
        return result;
    }

    @Override
    public void close() {
        this._original.destroy();
    }

    @Override
    public void kill() throws IOException {
        this._original.destroy();
    }

    @Override
    public boolean isDaemon() {
        return this._isDaemon;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof LocalGeneratedProcess)) {
            result = false;
        } else {
            LocalGeneratedProcess that = (LocalGeneratedProcess)o;
            Long id = this.getId();
            result = id != null ? id.equals(that.getId()) : that.getId() == null;
        }
        return result;
    }

    public int hashCode() {
        Long id = this.getId();
        return id != null ? (int)(id ^ id >>> 32) : 0;
    }

    public String toString() {
        return "Process #" + this.getId();
    }
}

