/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.local;

import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.DummyProcess;
import org.echocat.jomon.process.Signal;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.jomon.process.local.LocalGeneratedProcessImpl;
import org.echocat.jomon.process.local.LocalGeneratedProcessRequirement;
import org.echocat.jomon.process.local.LocalProcess;
import org.echocat.jomon.process.local.LocalProcessQuery;
import org.echocat.jomon.process.local.ProcessPidResolver;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.io.UncheckedIOException;
import org.echocat.jomon.runtime.repository.QueryableRepository;

@ThreadSafe
public abstract class LocalProcessRepository
implements QueryableRepository<LocalProcessQuery, Long, LocalProcess>,
Generator<LocalGeneratedProcess, LocalGeneratedProcessRequirement>,
AutoCloseable {
    private static final LocalProcessRepository INSTANCE = LocalProcessRepository.createInstance();

    @Nonnull
    public static LocalProcessRepository getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static LocalProcessRepository processRepository() {
        return LocalProcessRepository.getInstance();
    }

    @Nullable
    public LocalProcess findOneBy(@Nonnull Process process) {
        return this.findOneBy(this.getIdOf(process));
    }

    public LocalProcess findOneBy(@Nonnull Long id) {
        return this.findOneBy((LocalProcessQuery)LocalProcessQuery.query().withId(id));
    }

    public LocalProcess findOneBy(@Nonnull LocalProcessQuery query) {
        return (LocalProcess)CollectionUtils.findFirstOf((Iterator)this.findBy(query));
    }

    public long countBy(@Nonnull LocalProcessQuery query) {
        return CollectionUtils.countElementsOf((Iterator)this.findBy(query));
    }

    @Nonnull
    public LocalGeneratedProcess generate(@Nonnull LocalGeneratedProcessRequirement requirement) throws UncheckedIOException {
        Process original;
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(requirement.getCompleteCommandLine());
        pb.environment().putAll(requirement.getEnvironment());
        pb.directory(requirement.getWorkingDirectory());
        try {
            original = pb.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        long id = this.getIdOf(original);
        LocalProcess placeHolder = this.findOneBy(id);
        LocalProcess process = placeHolder != null ? placeHolder : new DummyProcess.LocalDummyProcess(id);
        return this.toControllableProcess(process, original, requirement.isDaemon());
    }

    public abstract void send(@Nonnull LocalProcess var1, @Nonnull Signal var2);

    @Override
    public void close() {
    }

    public abstract boolean isAvailable();

    public abstract long getThisPid();

    protected long getIdOf(@Nonnull Process process) {
        return ProcessPidResolver.getInstance().resolvePidOf(process);
    }

    @Nonnull
    protected static LocalProcessRepository createInstance() {
        ServiceLoader<LocalProcessRepository> found = ServiceLoader.load(LocalProcessRepository.class);
        LocalProcessRepository processRepository = null;
        for (LocalProcessRepository candidate : found) {
            if (!candidate.isAvailable()) continue;
            processRepository = candidate;
            break;
        }
        if (processRepository == null) {
            throw new IllegalArgumentException("Could not find any matching implementation of " + LocalProcessRepository.class.getName() + " for this virtual machine.");
        }
        LocalProcessRepository.closeOnJvmShutdown(processRepository);
        return processRepository;
    }

    private static void closeOnJvmShutdown(final @Nonnull LocalProcessRepository processRepository) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                processRepository.close();
            }
        });
    }

    @Nonnull
    protected LocalGeneratedProcess toControllableProcess(@Nonnull LocalProcess placeHolder, @Nonnull Process original, boolean isDaemon) {
        return new LocalGeneratedProcessImpl(placeHolder, original, isDaemon);
    }
}

