/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.sigar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.process.sigar.SigarBinariesException;
import org.echocat.jomon.process.sigar.SigarFacade;
import org.echocat.jomon.process.sigar.SigarLoadException;
import org.echocat.jomon.runtime.exceptions.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigarFacadeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SigarFacadeFactory.class);
    private static final String SIGAR_VERSION = "1.6.4";
    private static final String BINARIES_PACKAGE_DIRECTORY_NAME = "sigarBinaries" + File.separator + "1.6.4";
    private static final String BINARIES_PACKAGE_FILE_NAME = "sigarBinaries-1.6.4.zip";
    private static final boolean AVIALABLE = SigarFacadeFactory.isAvialableInitialCheck();

    @Nonnull
    public static SigarFacade create() throws UnsupportedOperationException {
        if (!SigarFacadeFactory.isAvialable()) {
            throw new UnsupportedOperationException("Sigar is not available for this JVM.");
        }
        return new SigarFacade();
    }

    public static boolean isAvialable() {
        return AVIALABLE;
    }

    private static boolean isAvialableInitialCheck() {
        boolean result;
        try {
            SigarFacadeFactory.initializeSigar();
            result = true;
        }
        catch (SigarBinariesException e) {
            result = false;
            LOG.info("The sigar process repository implementation is not available. Could not find the sigar binaries in the classpath or the provided sigar binaries are not compatible with your current JVM and/or operation system.", (Throwable)e);
        }
        catch (Exception e) {
            if (ExceptionUtils.containsClassNotFoundException((Throwable)e, (String)"org.hyperic.sigar.")) {
                result = false;
                LOG.info("The sigar process repository implementation is not available. Could not find the sigar implementation in the classpath present. If you use Maven add the org.fusesource:sigar:1.6.4+ dependency. You can ignore this message if you do not want to use the sigar process implementation.");
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SigarLoadException("Could not load sigar: " + e.getMessage(), e);
        }
        return result;
    }

    private static void initializeSigar() throws Exception {
        File directory = SigarFacadeFactory.getDirectory();
        try {
            SigarFacadeFactory.copyFilesTo(directory);
        }
        catch (IOException e) {
            throw new SigarBinariesException("Could not copy sigarBinaries-1.6.4.zip to " + directory + ".", e);
        }
        SigarFacadeFactory.setLibraryPath(directory);
        Class<?> clazz = Class.forName("org.hyperic.sigar.Sigar");
        Method method = clazz.getMethod("load", new Class[0]);
        method.invoke(null, new Object[0]);
    }

    @Nonnull
    private static File getDirectory() {
        String temporaryDirectoryPath = System.getProperty("java.io.tmpdir", "tmp");
        File temporaryDirectory = new File(temporaryDirectoryPath);
        File sigarDirectory = new File(temporaryDirectory, BINARIES_PACKAGE_DIRECTORY_NAME);
        sigarDirectory.mkdirs();
        return sigarDirectory;
    }

    private static void copyFilesTo(@Nonnull File directory) throws IOException {
        try (InputStream is = SigarFacadeFactory.class.getResourceAsStream(BINARIES_PACKAGE_FILE_NAME);){
            if (is == null) {
                throw new SigarBinariesException("Could not find file: sigarBinaries-1.6.4.zip");
            }
            try (ZipInputStream zip = new ZipInputStream(is);){
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    File destinationFile;
                    if (!entry.isDirectory() && !(destinationFile = new File(directory, entry.getName())).exists()) {
                        destinationFile.getParentFile().mkdirs();
                        try (FileOutputStream os = new FileOutputStream(destinationFile);){
                            IOUtils.copy((InputStream)zip, (OutputStream)os);
                        }
                    }
                    entry = zip.getNextEntry();
                }
            }
        }
    }

    private static void setLibraryPath(@Nonnull File directory) {
        System.setProperty("org.hyperic.sigar.path", directory.getPath());
    }

    private SigarFacadeFactory() {
    }
}

