/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.unix;

import com.sun.jna.Platform;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.local.ProcessPidResolver;

public class UnixProcessPidResolver
extends ProcessPidResolver {
    protected static final Class<?> PROCESS_CLASS = UnixProcessPidResolver.findClass("java.lang.UNIXProcess");
    protected static final Field PROCESS_PID_FIELD = UnixProcessPidResolver.findFieldOf("pid", Integer.TYPE, PROCESS_CLASS);

    @Override
    public long resolvePidOf(@Nonnull Process process) {
        if (PROCESS_CLASS == null || PROCESS_PID_FIELD == null || !PROCESS_CLASS.isInstance(process)) {
            throw new IllegalArgumentException("Could not handle: " + process);
        }
        int pid = (Integer)this.getFieldValue(PROCESS_PID_FIELD, process);
        return pid;
    }

    @Override
    protected boolean couldHandleThisVirtualMachine() {
        boolean result = Platform.isFreeBSD() || Platform.isLinux() || Platform.isOpenBSD() || Platform.isSolaris() || Platform.isMac() ? PROCESS_PID_FIELD != null : false;
        return result;
    }

    @Override
    protected void init() {
    }
}

