/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.NetworkInterfaceQuery;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.iterators.IteratorUtils;
import org.echocat.jomon.runtime.repository.QueryableRepository;

public class NetworkInterfaceRepository
implements QueryableRepository<NetworkInterfaceQuery, String, NetworkInterface> {
    @Nonnull
    private static final NetworkInterfaceRepository INSTANCE = new NetworkInterfaceRepository();

    @Nonnull
    public static NetworkInterfaceRepository getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static NetworkInterfaceRepository networkInterfaceRepository() {
        return NetworkInterfaceRepository.getInstance();
    }

    @Nullable
    public NetworkInterface findOneBy(@Nonnull String name) {
        try {
            return NetworkInterface.getByName(name);
        }
        catch (SocketException e) {
            throw new RuntimeException("Could not query interface by name: " + name, e);
        }
    }

    @Nullable
    public NetworkInterface findOneBy(@Nonnull NetworkInterfaceQuery query) {
        return (NetworkInterface)CollectionUtils.findFirstOf(this.findBy(query));
    }

    @Nonnull
    public CloseableIterator<NetworkInterface> findBy(@Nonnull NetworkInterfaceQuery query) {
        try {
            return IteratorUtils.filter((Iterator)Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), (Predicate)query);
        }
        catch (SocketException e) {
            throw new RuntimeException("Could not query interface by query.", e);
        }
    }

    public long countBy(@Nonnull NetworkInterfaceQuery query) {
        return CollectionUtils.countElementsOf(this.findBy(query));
    }
}

