/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.StringUtils;

public class UrlUtils {
    private static final Pattern NORMALIZE_URL_PATTERN = Pattern.compile("[^/]+/\\.\\./");

    @Nonnull
    public static String makeUrlAbsolute(@Nonnull String baseUrl, @Nonnull String url) {
        String absoluteUrl;
        boolean hasProtocol;
        int i = url.indexOf(58);
        int j = url.indexOf(63);
        boolean bl = hasProtocol = i > 0 && (j == -1 || i < j);
        if (hasProtocol) {
            absoluteUrl = url;
        } else if (url.startsWith("/")) {
            i = baseUrl.indexOf("://");
            i = baseUrl.indexOf("/", i + 3);
            absoluteUrl = baseUrl.substring(0, i) + url;
        } else {
            i = baseUrl.indexOf(63);
            if (i == -1) {
                i = baseUrl.length();
            }
            if ((j = baseUrl.indexOf(35)) == -1) {
                j = baseUrl.length();
            }
            i = Math.min(i, j);
            i = baseUrl.lastIndexOf(47, i);
            absoluteUrl = baseUrl.substring(0, i) + '/' + url;
            Matcher m = NORMALIZE_URL_PATTERN.matcher(absoluteUrl);
            while (m.find()) {
                absoluteUrl = m.replaceFirst("");
                m = NORMALIZE_URL_PATTERN.matcher(absoluteUrl);
            }
        }
        return absoluteUrl;
    }

    @Nonnull
    public static String makeRelative(@Nonnull String url) {
        String result = url;
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String withoutScheme = UrlUtils.removeScheme(url);
            String[] splits = withoutScheme.split("/", 2);
            result = splits.length > 1 ? "/" + splits[1] : "/";
        }
        return result;
    }

    @Nonnull
    public static String removeScheme(@Nonnull String url) {
        String[] splits;
        String result = url;
        if (StringUtils.isNotBlank((CharSequence)url) && url.contains("://") && (splits = url.split("://", 2)).length > 1) {
            result = splits[1];
        }
        return result;
    }

    private UrlUtils() {
    }
}

