/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.format;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.echocat.jomon.format.FormatUtils;
import org.echocat.jomon.format.FormatterSupport;
import org.echocat.jomon.format.Source;
import org.echocat.jomon.format.Target;
import org.echocat.jomon.runtime.util.Hints;

public class BasicFormatter
extends FormatterSupport {
    @Override
    public void format(@Nonnull Source source, @Nonnull Target target, @Nullable Hints hints) throws IllegalArgumentException, IOException {
        Source.Format sourceFormat = source.getFormat();
        Target.Format targetFormat = target.getFormat();
        if (sourceFormat.equals(Source.Format.textPlain) && targetFormat.equals(Target.Format.textPlain) || sourceFormat.equals(Source.Format.html) && targetFormat.equals(Target.Format.html)) {
            this.copy(source, target);
        } else if (sourceFormat.equals(Source.Format.html) && targetFormat.equals(Target.Format.textPlain)) {
            this.htmlToPlainText(source, target);
        } else if (sourceFormat.equals(Source.Format.textPlain) && targetFormat.equals(Target.Format.html)) {
            String input = IOUtils.toString((Reader)source.getReader());
            StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)input, target.getWriter());
        } else {
            throw new IllegalArgumentException("Could not handle the combination of " + source + " and " + target + ".");
        }
    }

    protected void htmlToPlainText(@Nonnull Source from, @Nonnull Target to) throws IOException {
        FormatUtils.htmlToPlainText(from.getReader(), to.getWriter());
    }

    protected void copy(@Nonnull Source from, @Nonnull Target to) throws IOException {
        IOUtils.copy((Reader)from.getReader(), (Writer)to.getWriter());
    }

    @Override
    public boolean canHandle(@Nonnull Source source, @Nonnull Target target, @Nullable Hints hints) {
        return this.canHandle(source) && this.canHandle(target);
    }

    protected boolean canHandle(@Nonnull Source source) {
        Source.Format sourceFormat = source.getFormat();
        return Source.Format.html.equals(sourceFormat) || Source.Format.textPlain.equals(sourceFormat);
    }

    protected boolean canHandle(@Nonnull Target target) {
        Target.Format targetFormat = target.getFormat();
        return Target.Format.html.equals(targetFormat) || Target.Format.textPlain.equals(targetFormat);
    }
}

