/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.format;

import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.format.Format;

public class Source {
    private final Format _format;
    private final Reader _reader;

    @Nonnull
    public static Source sourceOf(@Nonnull Format format, @Nonnull Reader reader) {
        return new Source(format, reader);
    }

    @Nonnull
    public static Source sourceOf(@Nonnull Reader reader) {
        return Source.sourceOf(Format.textPlain, reader);
    }

    @Nonnull
    public static Source sourceOf(@Nonnull Format format, @Nonnull String content) {
        return Source.sourceOf(format, new StringReader(content));
    }

    @Nonnull
    public static Source sourceOf(@Nonnull String content) {
        return Source.sourceOf(Format.textPlain, content);
    }

    public Source(@Nonnull Format format, @Nonnull Reader reader) {
        this._format = format;
        this._reader = reader;
    }

    @Nonnull
    public Format getFormat() {
        return this._format;
    }

    @Nonnull
    public Reader getReader() {
        return this._reader;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof Source)) {
            result = false;
        } else {
            Source that = (Source)o;
            result = this.getFormat().equals(that.getFormat()) && this.getReader().equals(that.getReader());
        }
        return result;
    }

    public int hashCode() {
        int result = this.getFormat().hashCode();
        result = 31 * result + this.getReader().hashCode();
        return result;
    }

    public String toString() {
        return "Source of " + this.getFormat() + ": " + this.getReader();
    }

    public static interface Format
    extends org.echocat.jomon.format.Format {
        public static final Format textPlain = new Impl("textPlain");
        public static final Format html = new Impl("html");

        @Immutable
        @ThreadSafe
        public static class Impl
        extends Format.Impl
        implements Format {
            public Impl(@Nonnull String name) {
                super(name, Format.class);
            }
        }
    }
}

