/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.format;

import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.format.Format;

public class Target {
    private final Format _format;
    private final Writer _writer;

    @Nonnull
    public static Target targetOf(@Nonnull Format format, @Nonnull Writer writer) {
        return new Target(format, writer);
    }

    @Nonnull
    public static Target targetOf(@Nonnull Writer writer) {
        return Target.targetOf(Format.textPlain, writer);
    }

    public Target(@Nonnull Format format, @Nonnull Writer writer) {
        this._format = format;
        this._writer = writer;
    }

    @Nonnull
    public Format getFormat() {
        return this._format;
    }

    @Nonnull
    public Writer getWriter() {
        return this._writer;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof Target)) {
            result = false;
        } else {
            Target that = (Target)o;
            result = this.getFormat().equals(that.getFormat()) && this.getWriter().equals(that.getWriter());
        }
        return result;
    }

    public int hashCode() {
        int result = this.getFormat().hashCode();
        result = 31 * result + this.getWriter().hashCode();
        return result;
    }

    public String toString() {
        return "Target of " + this.getFormat() + ": " + this.getWriter();
    }

    public static interface Format
    extends org.echocat.jomon.format.Format {
        public static final Format textPlain = new Impl("textPlain");
        public static final Format html = new Impl("html");

        @Immutable
        @ThreadSafe
        public static class Impl
        extends Format.Impl
        implements Format {
            public Impl(@Nonnull String name) {
                super(name, Format.class);
            }
        }
    }
}

