/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.format.label;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.format.label.LabelSupport;

@ThreadSafe
@Immutable
public class StaticLabel
extends LabelSupport {
    @Nonnull
    private final Map<Locale, MessageFormat> _localeToFormat = new ConcurrentHashMap<Locale, MessageFormat>();
    @Nonnull
    private final String _content;

    public StaticLabel(@Nonnull String content) {
        this._content = content;
    }

    @Nonnull
    public String toLocalized(@Nonnull Locale locale, Object ... arguments) {
        String result = arguments != null && arguments.length > 0 ? this.messageFormatFor(locale).format(arguments) : this._content;
        return result;
    }

    @Nonnull
    protected MessageFormat messageFormatFor(@Nonnull Locale locale) {
        MessageFormat format = this._localeToFormat.get(locale);
        if (format == null) {
            format = new MessageFormat(this._content, locale);
            this._localeToFormat.put(locale, format);
        }
        return format;
    }
}

