/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.format.mylyn;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.format.BasicFormatProvider;
import org.echocat.jomon.format.Format;
import org.echocat.jomon.format.FormatProviderSupport;
import org.echocat.jomon.format.Source;
import org.echocat.jomon.format.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MylynAssignmentsSupport<F extends Format>
extends FormatProviderSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MylynAssignmentsSupport.class);
    public static final String ASSIGNMENTS_RESOURCE_NAME_PREFIX = "META-INF/assignments/";
    private final Map<F, Class<?>> _formatToType;
    private final Map<String, F> _nameToFormat;

    protected MylynAssignmentsSupport(@Nonnull Class<F> formatType, @Nullable Map<F, Class<?>> formatToType) {
        this._formatToType = formatToType != null ? formatToType : Collections.emptyMap();
        this._nameToFormat = new LinkedHashMap<String, F>(this._formatToType.size(), 1.0f);
        for (Format format : formatToType.keySet()) {
            if (Source.Format.class.isAssignableFrom(formatType) && BasicFormatProvider.NAME_TO_SOURCE_FORMAT.containsKey(format.getName()) || Target.Format.class.isAssignableFrom(formatType) && BasicFormatProvider.NAME_TO_TARGET_FORMAT.containsKey(format.getName())) continue;
            this._nameToFormat.put(format.getName(), format);
        }
    }

    public MylynAssignmentsSupport(@Nonnull Class<F> formatType, @Nonnull String basicTypeName, @Nullable ClassLoader classLoader) {
        this(formatType, MylynAssignmentsSupport.loadFormatToDocumentBuilderType(classLoader, formatType, basicTypeName));
    }

    public MylynAssignmentsSupport(@Nonnull Class<F> formatType, @Nonnull String basicTypeName) {
        this(formatType, basicTypeName, null);
    }

    @Nullable
    public Class<?> findTypeFor(@Nonnull F format) {
        return this._formatToType.get(format);
    }

    @Nullable
    protected F findFormatFor(@Nonnull String name) {
        return (F)((Format)this._nameToFormat.get(name));
    }

    @Nonnull
    public static <F extends Format> Map<F, Class<?>> loadFormatToDocumentBuilderType(@Nullable ClassLoader preferredClassLoader, @Nonnull Class<F> formatType, @Nonnull String basicTypeName) {
        ClassLoader classLoader = preferredClassLoader != null ? preferredClassLoader : Thread.currentThread().getContextClassLoader();
        Class<?> basicType = MylynAssignmentsSupport.findType(classLoader, basicTypeName);
        Map<Object, Object> result = basicType != null ? MylynAssignmentsSupport.loadFormatToType(classLoader, basicType, formatType) : Collections.emptyMap();
        return result;
    }

    @Nonnull
    private static <F extends Format> Map<F, Class<?>> loadFormatToType(@Nonnull ClassLoader classLoader, @Nonnull Class<?> basicType, @Nonnull Class<F> formatType) {
        LinkedHashMap result = new LinkedHashMap();
        Iterator<URL> i = MylynAssignmentsSupport.resourcesIteratorFor(classLoader, basicType);
        while (i.hasNext()) {
            URL resource = i.next();
            Map<String, String> plainAssignments = MylynAssignmentsSupport.readPlainAssignmentsFrom(resource);
            for (Map.Entry<String, String> nameToType : plainAssignments.entrySet()) {
                String formatName = nameToType.getKey().trim();
                String typeName = nameToType.getValue().trim();
                if (formatName.isEmpty() || typeName.isEmpty()) continue;
                Class<?> type = MylynAssignmentsSupport.findType(classLoader, typeName);
                if (type != null) {
                    if (!basicType.isAssignableFrom(type)) {
                        throw new IllegalStateException("In '" + resource + "' was the class " + typeName + " for format type '" + formatName + "' provided. But this is no instance of " + basicType.getName() + ".");
                    }
                    result.put(MylynAssignmentsSupport.createFormatBy(formatType, formatName), type);
                    continue;
                }
                LOG.info("Could not initialize format type '" + formatName + "' because could not find the class in classpath: " + typeName);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    @Nonnull
    private static <F extends Format> F createFormatBy(@Nonnull Class<F> formatType, @Nonnull String formatName) {
        Format result;
        if (Source.Format.class.equals(formatType)) {
            result = (Format)formatType.cast(BasicFormatProvider.NAME_TO_SOURCE_FORMAT.containsKey(formatName) ? BasicFormatProvider.NAME_TO_SOURCE_FORMAT.get(formatName) : new Source.Format.Impl(formatName));
        } else if (Target.Format.class.equals(formatType)) {
            result = (Format)formatType.cast(BasicFormatProvider.NAME_TO_TARGET_FORMAT.containsKey(formatName) ? BasicFormatProvider.NAME_TO_TARGET_FORMAT.get(formatName) : new Target.Format.Impl(formatName));
        } else {
            throw new IllegalArgumentException("Don't know how to handle: " + formatType.getName());
        }
        return (F)result;
    }

    @Nullable
    public static Class<?> findType(@Nonnull ClassLoader classLoader, @Nonnull String typeName) {
        Class<?> result;
        try {
            result = classLoader.loadClass(typeName);
        }
        catch (ClassNotFoundException ignored) {
            result = null;
        }
        return result;
    }

    @Nonnull
    private static Iterator<URL> resourcesIteratorFor(@Nonnull ClassLoader classLoader, @Nonnull Class<?> basicType) {
        UnmodifiableIterator resources;
        try {
            resources = Iterators.forEnumeration(classLoader.getResources(ASSIGNMENTS_RESOURCE_NAME_PREFIX + basicType.getName()));
        }
        catch (IOException ignored) {
            resources = Collections.emptyIterator();
        }
        return resources;
    }

    @Nonnull
    private static Map<String, String> readPlainAssignmentsFrom(@Nonnull URL resource) {
        Properties assignments = new Properties();
        try (InputStream is = resource.openStream();
             InputStreamReader reader = new InputStreamReader(is);){
            assignments.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read " + resource + ".", e);
        }
        return assignments;
    }
}

