/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.echocat.jomon.runtime.util.ProducingType;
import org.echocat.jomon.runtime.util.Value;
import org.echocat.jomon.runtime.util.ValueProducer;

@NotThreadSafe
public class CacheEntry<K, V> {
    @Nonnull
    private final K _key;
    @Nullable
    private Value<V> _value;
    @Nonnegative
    private long _created;
    @Nullable
    private Long _expireAt;
    @Nonnegative
    private long _lastAccessed;
    @Nonnegative
    private int _hits;
    @Nullable
    private CacheEntry<K, V> _next;
    @Nullable
    private CacheEntry<K, V> _previous;

    public CacheEntry(@Nullable K key, @Nullable Long expireAfter, @Nullable Value<V> value) {
        this._key = key;
        this.setValue(expireAfter, value);
    }

    public CacheEntry(@Nullable K key, @Nullable Long expireAfter, @Nullable V value) {
        this._key = key;
        this.setValue(expireAfter, value);
    }

    public CacheEntry(@Nullable K key, @Nullable Long expireAfter, @Nullable ValueProducer<K, V> producer, @Nonnull ProducingType producingType) {
        this._key = key;
        this.setValue(expireAfter, producer, producingType);
    }

    @Nullable
    public K getKey() {
        return this._key;
    }

    public void setValue(@Nullable Long expireAfter, @Nullable V value) {
        this.setValue(expireAfter, (Value<V>)new Value.Fixed(value));
    }

    public void setValue(@Nullable Long expireAfter, @Nullable ValueProducer<K, V> producer, @Nonnull ProducingType producingType) {
        this.setValue(expireAfter, (Value<V>)(producer != null ? new Value.Lazy(this._key, producer, producingType) : new Value.Fixed(null)));
    }

    protected void setValue(@Nullable Long expireAfter, @Nonnull Value<V> entry) {
        this._value = entry;
        this._lastAccessed = this._created = System.currentTimeMillis();
        this._expireAt = expireAfter != null ? Long.valueOf(this._created + expireAfter) : null;
    }

    @Nullable
    public Value<V> getValue() {
        return this._value;
    }

    public void setPrevious(@Nullable CacheEntry<K, V> previous) {
        this._previous = previous;
    }

    @Nullable
    public CacheEntry<K, V> getPrevious() {
        return this._previous;
    }

    public void setNext(@Nullable CacheEntry<K, V> next) {
        this._next = next;
    }

    @Nullable
    public CacheEntry<K, V> getNext() {
        return this._next;
    }

    @Nonnegative
    public long getCreated() {
        return this._created;
    }

    @Nullable
    public Long getExpire() {
        return this._expireAt;
    }

    @Nonnegative
    public long getLastAccessed() {
        return this._lastAccessed;
    }

    @Nonnegative
    public int getHits() {
        return this._hits;
    }

    public void hit() {
        this._lastAccessed = System.currentTimeMillis();
        ++this._hits;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof CacheEntry)) {
            result = false;
        } else {
            K thisKey = this.getKey();
            K thatKey = ((CacheEntry)o).getKey();
            result = thisKey != null ? thisKey.equals(thatKey) : thatKey == null;
        }
        return result;
    }

    public int hashCode() {
        K thisKey = this.getKey();
        return thisKey != null ? thisKey.hashCode() : 0;
    }

    public String toString() {
        return this.getKey() + "=>" + this.getValue();
    }
}

