/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.Cache;

public abstract class CacheSupport<K, V>
implements Cache<K, V> {
    private final Class<? extends K> _keyType;
    private final Class<? extends V> _valueType;

    protected CacheSupport(@Nonnull Class<? extends K> keyType, @Nonnull Class<? extends V> valueType) {
        this._keyType = keyType;
        this._valueType = valueType;
    }

    protected void checkKey(@Nullable K key) {
        if (key != null && !this._keyType.isInstance(key)) {
            throw new IllegalArgumentException("Key '" + key + "' is not of required type: " + this._keyType.getName());
        }
    }

    protected void checkValue(@Nullable V value) {
        if (value != null && !this._valueType.isInstance(value)) {
            throw new IllegalArgumentException("Value '" + value + "' is not of required type: " + this._valueType.getName());
        }
    }

    protected void checkValueAfterProducing(@Nullable V value) {
        if (value != null && !this._valueType.isInstance(value)) {
            throw new IllegalStateException("Value '" + value + "' is not of required type: " + this._valueType.getName());
        }
    }

    @Override
    @Nonnull
    public Class<? extends K> getKeyType() {
        return this._keyType;
    }

    @Override
    @Nonnull
    public Class<? extends V> getValueType() {
        return this._valueType;
    }
}

