/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.cache.CacheEntry;
import org.echocat.jomon.cache.InMemoryBasedCacheSupport;

@ThreadSafe
public class LfuCache<K, V>
extends InMemoryBasedCacheSupport<K, V> {
    public LfuCache(@Nonnull Class<? extends K> keyType, @Nonnull Class<? extends V> valueType) {
        super(keyType, valueType);
    }

    @Override
    protected void updateListAfterPut(CacheEntry<K, V> newEntry) {
        newEntry.setPrevious(this._last);
        if (this._last != null) {
            this._last.setNext(newEntry);
        }
        this.setLast(newEntry);
    }

    @Override
    protected void updateListAfterHit(CacheEntry<K, V> entry) {
        if (entry != null && !entry.equals(this._first) && entry.getHits() > entry.getPrevious().getHits()) {
            CacheEntry<K, V> beforePrevious = entry.getPrevious().getPrevious();
            CacheEntry<K, V> previous = entry.getPrevious();
            CacheEntry<K, V> next = entry.getNext();
            if (beforePrevious != null) {
                beforePrevious.setNext(entry);
            } else {
                this._first = entry;
            }
            entry.setPrevious(beforePrevious);
            previous.setPrevious(entry);
            previous.setNext(next);
            entry.setNext(previous);
            if (next == null) {
                this.setLast(previous);
            } else {
                next.setPrevious(previous);
            }
        }
    }
}

