/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache;

import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.cache.CacheEntry;
import org.echocat.jomon.cache.InMemoryBasedCacheSupport;

@ThreadSafe
public class LruCache<K, V>
extends InMemoryBasedCacheSupport<K, V> {
    public LruCache(@Nonnull Class<? extends K> keyType, @Nonnull Class<? extends V> valueType) {
        super(keyType, valueType);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void updateListAfterPut(CacheEntry<K, V> newEntry) {
        if (this._last == null) {
            this._last = newEntry;
            this._first = newEntry;
        } else {
            this._first.setPrevious(newEntry);
            newEntry.setNext(this._first);
            this.setFirst(newEntry);
        }
    }

    @Override
    protected void updateListAfterHit(CacheEntry<K, V> entry) {
        if (entry != null && !entry.equals(this._first)) {
            if (entry.equals(this._last)) {
                this.setLast(entry.getPrevious());
            } else {
                CacheEntry<K, V> previous = entry.getPrevious();
                CacheEntry<K, V> next = entry.getNext();
                previous.setNext(next);
                next.setPrevious(previous);
            }
            this._first.setPrevious(entry);
            entry.setNext(this._first);
            this.setFirst(entry);
        }
    }
}

