/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache.management;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.CombinedCache;
import org.echocat.jomon.cache.management.CacheCreator;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.cache.management.CacheProvider;
import org.echocat.jomon.cache.management.CombinedCacheDefinition;
import org.echocat.jomon.cache.management.FifoCacheCreator;
import org.echocat.jomon.cache.management.LfuCacheCreator;
import org.echocat.jomon.cache.management.LruCacheCreator;
import org.echocat.jomon.cache.management.ServletRequestBasedCacheCreator;

public class CombinedCacheCreator
implements CacheCreator {
    private static final Iterable<CacheCreator> DEFAULT_DELEGATES = Arrays.asList(new LruCacheCreator(), new LfuCacheCreator(), new FifoCacheCreator(), new ServletRequestBasedCacheCreator());
    private Iterable<CacheCreator> _delegates;

    public Iterable<CacheCreator> getDelegates() {
        return this._delegates;
    }

    public void setDelegates(Iterable<CacheCreator> delegates) {
        this._delegates = delegates;
    }

    @Override
    public boolean canHandleType(@Nonnull CacheDefinition<?, ?, ?> by) throws Exception {
        return by instanceof CombinedCacheDefinition || this.findDelegateFor(by) != null;
    }

    @Override
    @Nonnull
    public <K, V> Cache<K, V> create(@Nullable CacheProvider provider, @Nonnull CacheCreator master, @Nonnull CacheDefinition<K, V, ?> by) throws Exception {
        Cache<K, V> cache;
        if (by instanceof CombinedCacheDefinition) {
            cache = this.createCombined(provider, master, (CombinedCacheDefinition)by);
        } else {
            CacheCreator creator = this.findDelegateFor(by);
            if (creator == null) {
                throw new IllegalArgumentException("Could not handle definition " + by + ".");
            }
            cache = creator.create(provider, master, by);
        }
        return cache;
    }

    @Nonnull
    protected <K, V> CombinedCache<K, V> createCombined(@Nullable CacheProvider provider, @Nonnull CacheCreator master, @Nonnull CombinedCacheDefinition<K, V> by) throws Exception {
        List<CombinedCacheDefinition.IdentifiersToDefinition<K, V>> definitions = by.getDelegates();
        Cache[] delegates = new Cache[definitions != null ? definitions.size() : 0];
        if (definitions != null) {
            int i = 0;
            for (CombinedCacheDefinition.IdentifiersToDefinition<K, V> definition : definitions) {
                if (provider == null) {
                    delegates[i++] = this.create(null, master, definition.getDefinition());
                    continue;
                }
                if (definition instanceof CombinedCacheDefinition.IdToDefinition) {
                    delegates[i++] = provider.provide(((CombinedCacheDefinition.IdToDefinition)definition).getId(), definition.getDefinition());
                    continue;
                }
                if (definition instanceof CombinedCacheDefinition.TypeAndVariantToDefinition) {
                    delegates[i++] = provider.provide(((CombinedCacheDefinition.TypeAndVariantToDefinition)definition).getForType(), ((CombinedCacheDefinition.TypeAndVariantToDefinition)definition).getVariant(), definition.getDefinition());
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        return new CombinedCache(by.getKeyType(), by.getValueType(), delegates);
    }

    @Nullable
    protected <K, V> CacheCreator findDelegateFor(@Nonnull CacheDefinition<K, V, ?> by) throws Exception {
        Iterable<CacheCreator> delegates = this._delegates;
        CacheCreator result = null;
        if (delegates != null) {
            for (CacheCreator delegate : delegates) {
                if (!delegate.canHandleType(by)) continue;
                result = delegate;
                break;
            }
        }
        if (result == null) {
            for (CacheCreator delegate : DEFAULT_DELEGATES) {
                if (!delegate.canHandleType(by)) continue;
                result = delegate;
                break;
            }
        }
        return result;
    }
}

