/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache.management;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.ProducingTypeEnabledCache;
import org.echocat.jomon.cache.management.CacheCreator;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.cache.management.CacheProvider;
import org.echocat.jomon.cache.management.DefaultCacheDefinition;
import org.echocat.jomon.cache.management.LimitedCacheCreatorSupport;
import org.echocat.jomon.runtime.util.ProducingType;

public abstract class DefaultCacheCreatorSupport
extends LimitedCacheCreatorSupport {
    private ProducingType _defaultProducingType;

    @Nullable
    public ProducingType getDefaultProducingType() {
        return this._defaultProducingType;
    }

    public void setDefaultProducingType(@Nullable ProducingType defaultProducingType) {
        this._defaultProducingType = defaultProducingType;
    }

    @Override
    @Nonnull
    public <K, V> Cache<K, V> create(@Nullable CacheProvider cacheProvider, @Nonnull CacheCreator master, @Nonnull CacheDefinition<K, V, ?> by) throws Exception {
        Cache<K, V> result = super.create(cacheProvider, master, by);
        if (result instanceof ProducingTypeEnabledCache && by instanceof DefaultCacheDefinition) {
            ProducingType producingType = ((DefaultCacheDefinition)by).getProducingType();
            if (producingType != null) {
                ((ProducingTypeEnabledCache)result).setProducingType(producingType);
            } else if (this._defaultProducingType != null) {
                ((ProducingTypeEnabledCache)result).setProducingType(this._defaultProducingType);
            }
        }
        return result;
    }
}

