/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache.management;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.CacheListener;
import org.echocat.jomon.cache.CacheUtils;
import org.echocat.jomon.cache.ClearableCache;
import org.echocat.jomon.cache.IdentifiedCache;
import org.echocat.jomon.cache.ListenerEnabledCache;
import org.echocat.jomon.cache.management.CacheCreator;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.cache.management.CacheRepository;
import org.echocat.jomon.cache.management.CreationCacheListener;
import org.echocat.jomon.cache.management.DestroyCacheListener;
import org.echocat.jomon.cache.management.IllegalCacheDefinitionException;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.util.Entry;
import org.echocat.jomon.runtime.util.ResourceUtils;

public class DefaultCacheRepository
implements CacheRepository,
AutoCloseable {
    private final Map<String, Cache<?, ?>> _idToCache = new HashMap();
    private final CacheCreator _cacheCreator;
    private CacheDefinition<?, ?, ?> _defaultDefinition;
    private Map<String, CacheDefinition<?, ?, ?>> _overwrittenCacheDefinitions;
    private Collection<CacheListener> _listeners;

    public DefaultCacheRepository(@Nonnull CacheCreator cacheCreator) {
        this._cacheCreator = cacheCreator;
    }

    @Nullable
    public CacheDefinition<?, ?, ?> getDefaultDefinition() {
        return this._defaultDefinition;
    }

    public void setDefaultDefinition(@Nullable CacheDefinition<?, ?, ?> defaultDefinition) {
        this._defaultDefinition = defaultDefinition;
    }

    @Nullable
    public Map<String, CacheDefinition<?, ?, ?>> getOverwrittenCacheDefinitions() {
        return this._overwrittenCacheDefinitions;
    }

    public void setOverwrittenCacheDefinitions(@Nullable Map<String, CacheDefinition<?, ?, ?>> overwrittenCacheDefinitions) {
        this._overwrittenCacheDefinitions = overwrittenCacheDefinitions;
    }

    @Nullable
    public Collection<CacheListener> getListeners() {
        return this._listeners;
    }

    public void setListeners(@Nullable Collection<CacheListener> listeners) {
        this._listeners = listeners;
    }

    @Override
    @Nonnull
    public <K, V> Cache<K, V> provide(@Nonnull Class<?> forType, @Nullable CacheDefinition<K, V, ?> defaultDefinition) throws IllegalCacheDefinitionException {
        return this.provide(forType, null, defaultDefinition);
    }

    @Override
    @Nonnull
    public <K, V> Cache<K, V> provide(@Nonnull Class<?> forType, @Nullable String variant, @Nullable CacheDefinition<K, V, ?> defaultDefinition) throws IllegalCacheDefinitionException {
        String id = variant != null ? forType.getName() + "." + variant : forType.getName();
        return this.provide(id, defaultDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <K, V> Cache<K, V> provide(@Nonnull String id, @Nullable CacheDefinition<K, V, ?> defaultDefinition) {
        CacheUtils.assertValidCacheId(id);
        Map<String, Cache<?, ?>> map = this._idToCache;
        synchronized (map) {
            Cache<Object, Object> cache = this._idToCache.get(id);
            if (cache == null) {
                CacheDefinition<K, V, ?> definition = this.selectDefinitionBy(id, defaultDefinition);
                cache = this.create(id, definition);
                this._idToCache.put(id, cache);
            }
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <K, V> Cache<K, V> find(@Nonnull String id) {
        Map<String, Cache<?, ?>> map = this._idToCache;
        synchronized (map) {
            return this._idToCache.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, Cache<?, ?>> map = this._idToCache;
        synchronized (map) {
            for (Cache<?, ?> cache : this._idToCache.values()) {
                if (!(cache instanceof ClearableCache)) continue;
                ((ClearableCache)cache).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@Nonnull String id) {
        Map<String, Cache<?, ?>> map = this._idToCache;
        synchronized (map) {
            try {
                Cache<?, ?> cache = this._idToCache.get(id);
                if (cache != null) {
                    if (this.beforeDestroy(id, cache)) {
                        if (cache instanceof ClearableCache) {
                            ((ClearableCache)cache).clear();
                        }
                        this._idToCache.remove(id);
                        this.afterDestroy(id, cache);
                    } else {
                        this._idToCache.remove(id);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not remove cache '" + id + "'.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Iterator<Entry<String, Cache<?, ?>>> iterator() {
        HashSet idToCache;
        Map<String, Cache<?, ?>> map = this._idToCache;
        synchronized (map) {
            idToCache = new HashSet(this._idToCache.entrySet());
        }
        return new ConvertingIterator<Map.Entry<String, Cache<?, ?>>, Entry<String, Cache<?, ?>>>(idToCache.iterator()){

            protected Entry<String, Cache<?, ?>> convert(Map.Entry<String, Cache<?, ?>> input) {
                return new Entry.Impl((Object)input.getKey(), input.getValue());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void close() throws Exception {
        Map<String, Cache<?, ?>> map = this._idToCache;
        synchronized (map) {
            Iterator<Map.Entry<String, Cache<?, ?>>> i = this._idToCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Cache<?, ?>> entry = i.next();
                String id = entry.getKey();
                Cache<?, ?> cache = entry.getValue();
                try {
                    if (this.beforeDestroy(id, cache)) {
                        ResourceUtils.closeQuietlyIfAutoCloseable(cache);
                        i.remove();
                        this.afterDestroy(id, cache);
                        continue;
                    }
                    i.remove();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not remove cache '" + id + "'.", e);
                }
            }
        }
    }

    @Nonnull
    protected <K, V> CacheDefinition<K, V, ?> selectDefinitionBy(@Nonnull String id, @Nullable CacheDefinition<K, V, ?> specifiedDefaultDefinition) {
        CacheDefinition<Object, Object, ?> result;
        Map<String, CacheDefinition<?, ?, ?>> overwrittenCacheDefinitions = this._overwrittenCacheDefinitions;
        CacheDefinition<?, ?, ?> cacheDefinition = result = overwrittenCacheDefinitions != null ? overwrittenCacheDefinitions.get(id) : null;
        if (result == null) {
            result = specifiedDefaultDefinition;
        }
        if (result == null) {
            result = this._defaultDefinition;
        }
        if (result == null) {
            throw new IllegalCacheDefinitionException("There could no cache definition be selected for '" + id + "'.");
        }
        return result;
    }

    @Nonnull
    protected <K, V> Cache<K, V> create(@Nonnull String id, @Nonnull CacheDefinition<K, V, ?> definition) {
        try {
            Cache<K, V> cache;
            if (this._cacheCreator.canHandleType(definition)) {
                if (!this.beforeCreate(id, definition)) {
                    throw new IllegalCacheDefinitionException("Listener denied creation of cache by " + definition + ".");
                }
                cache = this._cacheCreator.create(this, this._cacheCreator, definition);
                if (cache instanceof IdentifiedCache) {
                    ((IdentifiedCache)cache).setId(id);
                }
                if (cache instanceof ListenerEnabledCache) {
                    ((ListenerEnabledCache)cache).setListeners(this._listeners);
                }
            } else {
                throw new IllegalCacheDefinitionException("Could not provide a cache by " + definition + ".");
            }
            this.afterCreate(id, definition, cache);
            return cache;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create cache '" + id + "' by " + definition + ".", e);
        }
    }

    protected <K, V> boolean beforeCreate(@Nonnull String id, @Nonnull CacheDefinition<K, V, ?> definition) throws Exception {
        Collection<CacheListener> listeners = this._listeners;
        boolean result = true;
        if (listeners != null) {
            for (CacheListener listener : listeners) {
                if (!(listener instanceof CreationCacheListener) || ((CreationCacheListener)listener).beforeCreate(id, definition)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected <K, V> void afterCreate(@Nonnull String id, @Nonnull CacheDefinition<K, V, ?> definition, @Nonnull Cache<?, ?> cache) {
        Collection<CacheListener> listeners = this._listeners;
        if (listeners != null) {
            for (CacheListener listener : listeners) {
                if (!(listener instanceof CreationCacheListener)) continue;
                ((CreationCacheListener)listener).afterCreate(id, definition, cache);
            }
        }
    }

    protected <K, V> boolean beforeDestroy(@Nonnull String id, @Nonnull Cache<K, V> cache) throws Exception {
        Collection<CacheListener> listeners = this._listeners;
        boolean result = true;
        if (listeners != null) {
            for (CacheListener listener : listeners) {
                if (!(listener instanceof CreationCacheListener) || ((DestroyCacheListener)listener).beforeDestroy(id, cache)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected <K, V> void afterDestroy(@Nonnull String id, @Nonnull Cache<K, V> cache) throws Exception {
        Collection<CacheListener> listeners = this._listeners;
        if (listeners != null) {
            for (CacheListener listener : listeners) {
                if (!(listener instanceof DestroyCacheListener)) continue;
                ((DestroyCacheListener)listener).afterDestroy(id, cache);
            }
        }
    }
}

