/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.service;

import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.net.HostService;
import org.echocat.jomon.net.Protocol;
import org.echocat.jomon.net.dns.SrvDnsEntryEvaluator;
import org.echocat.jomon.net.service.ServicesManager;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.jomon.runtime.util.ServiceTemporaryUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Resolver;

@ThreadSafe
public abstract class SrvEntryBasedServicesManager<I, O>
extends ServicesManager<I, O> {
    private static final Logger LOG = LoggerFactory.getLogger(SrvEntryBasedServicesManager.class);
    private static final Object[] EMPTY = new Object[0];
    private final Random _random = new Random();
    private final Lock _lock = new ReentrantLock();
    private final Protocol _protocol;
    private final String _service;
    private Resolver _resolver;
    private Containers<O> _containers;
    private Object[] _outputs;

    protected SrvEntryBasedServicesManager(@Nonnull Protocol protocol, @Nonnull String service) {
        this._protocol = protocol;
        this._service = service;
    }

    public Resolver getResolver() {
        return this._resolver;
    }

    public void setResolver(Resolver resolver) {
        this._resolver = resolver;
    }

    @Nonnull
    public String getService() {
        return this._service;
    }

    @Nonnull
    public Protocol getProtocol() {
        return this._protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void check(@Nonnull Collection<I> inputs) throws Exception, InterruptedException {
        Object[] oldOutputs;
        Collection<HostService> oldHostServices;
        Containers<O> newContainers = new Containers<O>();
        this._lock.lockInterruptibly();
        try {
            oldHostServices = this._containers != null ? this._containers.getCopyOfAllServices() : null;
            oldOutputs = this._outputs;
        }
        finally {
            this._lock.unlock();
        }
        SrvDnsEntryEvaluator evaluator = new SrvDnsEntryEvaluator(this._resolver);
        for (I input : inputs) {
            List<Container<O>> containers = this.getContainersFor(input, evaluator, oldHostServices);
            for (Container<O> container : containers) {
                newContainers.add(container);
            }
        }
        Object[] newOutputs = this.rebuildOutputs(newContainers);
        this._lock.lockInterruptibly();
        try {
            this.onContainersSwitch(this._containers, newContainers);
            this._containers = newContainers;
            this._outputs = newOutputs;
        }
        finally {
            this._lock.unlock();
        }
        if ((oldOutputs == null || oldOutputs.length > 0) && newOutputs.length == 0) {
            this.reportNoServicesAvailable();
        } else if (oldOutputs == null && newOutputs.length > 0) {
            LOG.info("The service " + this._service + " is now available and will be served by " + this.absoluteNumberOf(newOutputs) + " host(s).");
        } else if (oldOutputs != null && oldOutputs.length == 0 && newOutputs.length > 0) {
            LOG.info("The service " + this._service + " is now available again and will be served by " + this.absoluteNumberOf(newOutputs) + " host(s).");
        }
    }

    protected void onContainersSwitch(@Nullable Containers<O> oldContainers, @Nullable Containers<O> newContainers) {
        if (oldContainers != null) {
            for (Container<O> oldContainer : oldContainers) {
                if (newContainers != null && newContainers.containsOutput(oldContainer.getOutput())) continue;
                this.onContainerGone(oldContainer);
            }
        }
        if (newContainers != null) {
            for (Container<O> newContainer : newContainers) {
                if (oldContainers != null && oldContainers.containsOutput(newContainer.getOutput())) continue;
                this.onContainerEnter(newContainer);
            }
        }
    }

    protected void onContainerEnter(@Nonnull Container<O> container) {
    }

    protected void onContainerGone(@Nonnull Container<O> container) {
        ResourceUtils.closeQuietly(container);
    }

    protected void reportNoServicesAvailable() {
        LOG.warn("There are currently no remote hosts available for service " + this._service + ". If a client tries to use this service it will fail with a " + ServiceTemporaryUnavailableException.class.getSimpleName() + ".");
    }

    @Nonnegative
    protected int absoluteNumberOf(@Nonnull Object[] newOutputs) {
        HashSet absoluteObjects = new HashSet();
        Collections.addAll(absoluteObjects, newOutputs);
        return absoluteObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected List<Container<O>> getContainersFor(@Nonnull I input, @Nonnull SrvDnsEntryEvaluator evaluator, @Nullable Collection<HostService> oldHostServices) throws Exception {
        ArrayList<Container<O>> containers = new ArrayList<Container<O>>();
        InetSocketAddress inetSocketAddress = this.toInetSocketAddress(input);
        if (inetSocketAddress != null) {
            boolean success = false;
            try {
                for (HostService service : this.getServicesFor(evaluator, inetSocketAddress)) {
                    State oldState = this.getOldSateFor(service, oldHostServices);
                    Container<O> container = this.getContainerFor(input, oldState, service);
                    if (container == null) continue;
                    containers.add(container);
                }
                success = true;
            }
            finally {
                if (!success) {
                    ResourceUtils.closeQuietly(containers);
                }
            }
        }
        return containers;
    }

    @Nonnull
    protected List<HostService> getServicesFor(@Nonnull SrvDnsEntryEvaluator evaluator, @Nonnull InetSocketAddress inetSocketAddress) throws SocketException {
        List<Object> services;
        try {
            services = evaluator.lookup(this._service, this._protocol, inetSocketAddress.getHostName());
        }
        catch (SrvDnsEntryEvaluator.NoSuchSrvRecordException ignored) {
            services = inetSocketAddress.getAddress() != null ? Collections.singletonList(new HostService(inetSocketAddress, 0, 100, 1L)) : Collections.emptyList();
        }
        catch (UnknownHostException ignored) {
            services = Collections.emptyList();
        }
        return services;
    }

    @Nonnull
    protected State getOldSateFor(@Nonnull HostService service, @Nullable Collection<HostService> baseOnOldHostServices) {
        State oldState = baseOnOldHostServices == null ? State.unknown : (baseOnOldHostServices.contains(service) ? State.available : State.unavailable);
        return oldState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Container<O> getContainerFor(@Nonnull I input, @Nonnull State oldState, @Nonnull HostService service) throws Exception {
        Container<O> result;
        block7: {
            result = null;
            try {
                O output = this.tryGetOutputFor(input, service.getAddress(), oldState);
                if (output != null) {
                    boolean success = false;
                    try {
                        this.reportThere(service, oldState);
                        result = new Container<O>(service, output);
                        success = true;
                        break block7;
                    }
                    finally {
                        if (!success) {
                            ResourceUtils.closeQuietlyIfAutoCloseable(output);
                        }
                    }
                }
                this.reportGone(service, null, oldState);
            }
            catch (ServiceTemporaryUnavailableException e) {
                this.reportGone(service, e.getMessage(), oldState);
            }
        }
        return result;
    }

    @Nullable
    protected abstract InetSocketAddress toInetSocketAddress(@Nonnull I var1) throws Exception;

    @Nullable
    protected abstract O tryGetOutputFor(@Nonnull I var1, @Nonnull InetSocketAddress var2, @Nonnull State var3) throws Exception;

    public boolean isAvailable() {
        this._lock.lock();
        try {
            boolean bl = this._outputs != null && this._outputs.length > 0;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Nonnull
    protected Object[] getOutputs() {
        Object[] outputs = this._outputs;
        return outputs != null ? outputs : EMPTY;
    }

    @Override
    public void markAsGone(@Nonnull O service) throws InterruptedException {
        this.markAsGone(service, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsGone(@Nonnull O service, @Nullable String cause) throws InterruptedException {
        Container<O> container;
        this._lock.lockInterruptibly();
        try {
            Containers<O> containers = this._containers;
            if (containers == null) {
                throw new IllegalStateException();
            }
            container = containers.findByOutput(service);
            if (container != null) {
                containers.remove(container);
            }
            this._outputs = this.rebuildOutputs(containers);
        }
        finally {
            this._lock.unlock();
        }
        if (container != null) {
            this.reportGone(container.getService(), cause, State.available);
        }
    }

    protected void reportGone(@Nonnull HostService hostService, @Nullable String message, @Nonnull State oldState) {
        if (oldState == State.unknown || oldState == State.available) {
            StringBuilder sb = new StringBuilder();
            sb.append("The service ").append(this.formatForLogging(hostService)).append(" of ").append(this.getService());
            if (oldState == State.unknown) {
                sb.append(" seems to be not there and will be not available.");
            } else {
                sb.append(" seems to be gone and will be removed from the cluster.");
            }
            if (message != null) {
                sb.append(" Got: ");
                if (message.length() > 255) {
                    sb.append(message.substring(0, 255)).append("...");
                } else {
                    sb.append(message);
                }
            }
            LOG.info(sb.toString());
        }
    }

    protected void reportThere(@Nonnull HostService hostService, @Nonnull State oldState) {
        if (oldState == State.unknown || oldState == State.unavailable) {
            StringBuilder sb = new StringBuilder();
            sb.append("The service ").append(this.formatForLogging(hostService)).append(" of ").append(this.getService());
            if (oldState == State.unknown) {
                sb.append(" is now available.");
            } else {
                sb.append(" is back in the cluster.");
            }
            LOG.info(sb.toString());
        }
    }

    @Nonnull
    protected String formatForLogging(@Nonnull HostService hostService) {
        String output;
        InetSocketAddress address = hostService.getAddress();
        try {
            output = address.getAddress().getCanonicalHostName() + ":" + address.getPort();
        }
        catch (Exception ignored) {
            output = address.toString();
        }
        return output;
    }

    @Nonnull
    protected Object[] rebuildOutputs(@Nonnull Containers<O> containers) {
        List<Container<O>> newContainers = containers.getContainersByLowersPriority();
        int newArraySize = 0;
        for (Container<O> container : newContainers) {
            newArraySize += container.getService().getWeight();
        }
        Object[] outputs = new Object[newArraySize];
        int c = 0;
        for (Container<O> container : newContainers) {
            int weight = container.getService().getWeight();
            for (int i = 0; i < weight; ++i) {
                outputs[c++] = container.getOutput();
            }
        }
        return outputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected O tryTake() {
        SrvEntryBasedServicesManager srvEntryBasedServicesManager = this;
        synchronized (srvEntryBasedServicesManager) {
            int numberOfCurrentOutputs = this._outputs != null ? this._outputs.length : 0;
            return (O)(numberOfCurrentOutputs > 0 ? this._outputs[this._random.nextInt(numberOfCurrentOutputs)] : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            SrvEntryBasedServicesManager srvEntryBasedServicesManager = this;
            synchronized (srvEntryBasedServicesManager) {
                try {
                    this.onContainersSwitch(this._containers, null);
                }
                finally {
                    this._containers = null;
                    this._outputs = null;
                }
            }
        }
    }

    @Override
    public String toString() {
        String service = this._service;
        return service != null ? service : "<unknown>";
    }

    @ThreadSafe
    protected static class Container<O>
    implements AutoCloseable {
        private final O _output;
        private final HostService _service;

        public Container(@Nonnull HostService service, @Nonnull O output) {
            this._service = service;
            this._output = output;
        }

        @Nonnull
        public O getOutput() {
            return this._output;
        }

        @Nonnull
        public HostService getService() {
            return this._service;
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof Container)) {
                result = false;
            } else {
                Container that = (Container)o;
                result = this._service.equals((Object)that._service);
            }
            return result;
        }

        @Override
        public void close() throws Exception {
            if (this._output instanceof AutoCloseable) {
                ((AutoCloseable)this._output).close();
            }
        }

        public int hashCode() {
            return this._service.hashCode();
        }

        public String toString() {
            return this._service.toString() + ":" + this._output.toString();
        }
    }

    @NotThreadSafe
    protected static class Containers<O>
    implements Iterable<Container<O>> {
        private final Map<Integer, List<Container<O>>> _priorityToContainers = new TreeMap<Integer, List<Container<O>>>();
        private final Map<O, Container<O>> _outputToContainer = new HashMap<O, Container<O>>();

        protected Containers() {
        }

        public void add(@Nonnull Container<O> container) {
            int priority = container.getService().getPriority();
            List<Container<O>> containers = this._priorityToContainers.get(priority);
            if (containers == null) {
                containers = new ArrayList<Container<O>>();
                this._priorityToContainers.put(priority, containers);
            }
            containers.add(container);
            this._outputToContainer.put(container.getOutput(), container);
        }

        public void remove(@Nonnull Container<O> container) {
            int priority = container.getService().getPriority();
            List<Container<O>> containers = this._priorityToContainers.get(priority);
            if (containers != null) {
                containers.remove(container);
            }
            if (CollectionUtils.isEmpty(containers)) {
                this._priorityToContainers.remove(priority);
            }
            this._outputToContainer.remove(container.getOutput());
        }

        @Nullable
        public Container<O> findByOutput(@Nonnull O output) {
            Container<O> container = this._outputToContainer.get(output);
            return container;
        }

        public boolean containsOutput(@Nonnull O output) {
            return this._outputToContainer.containsKey(output);
        }

        @Nonnull
        public List<Container<O>> getContainersByLowersPriority() {
            List<Container<O>> result = !this._priorityToContainers.isEmpty() ? this._priorityToContainers.values().iterator().next() : Collections.emptyList();
            return result;
        }

        @Nonnull
        public Collection<HostService> getCopyOfAllServices() {
            HashSet<HostService> all = new HashSet<HostService>();
            for (List<Container<O>> containers : this._priorityToContainers.values()) {
                for (Container<O> container : containers) {
                    all.add(container.getService());
                }
            }
            return Collections.unmodifiableCollection(all);
        }

        @Override
        public Iterator<Container<O>> iterator() {
            return this._outputToContainer.values().iterator();
        }

        public boolean isEmpty() {
            return this._outputToContainer.isEmpty();
        }

        @Nonnegative
        public int size() {
            return this._outputToContainer.size();
        }
    }

    public static enum State {
        unknown,
        available,
        unavailable;

    }
}

