/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.service;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.net.Protocol;
import org.echocat.jomon.net.service.SrvEntryBasedServicesManager;
import org.echocat.jomon.runtime.util.ServiceTemporaryUnavailableException;

public abstract class UriBasedServicesManager
extends SrvEntryBasedServicesManager<URI, URI> {
    protected UriBasedServicesManager(@Nonnull String service) {
        super(Protocol.tcp, service);
        this.setCheckerThreadName("CheckServiceUris for " + this.getService() + "@" + this.getProtocol().getName());
    }

    @Override
    @Nullable
    protected InetSocketAddress toInetSocketAddress(@Nonnull URI input) throws Exception {
        InetSocketAddress result;
        String host = input.getHost();
        if (host == null) {
            throw new IllegalArgumentException("No host fond in: " + input);
        }
        int port = this.getPortFor(input);
        try {
            result = new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException ignored) {
            result = InetSocketAddress.createUnresolved(host, port);
        }
        return result;
    }

    @Nonnegative
    protected int getPortFor(@Nonnull URI input) throws Exception {
        int port = input.getPort();
        if (port < 0) {
            String scheme = input.getScheme();
            if ("http".equals(scheme)) {
                port = 80;
            } else if ("https".equals(scheme)) {
                port = 443;
            } else {
                throw new IllegalArgumentException("No port found in: " + input);
            }
        }
        return port;
    }

    @Override
    protected URI tryGetOutputFor(@Nonnull URI input, @Nonnull InetSocketAddress address, @Nonnull SrvEntryBasedServicesManager.State oldState) throws Exception {
        URI uri = this.toUri(input, address);
        this.checkUri(uri, oldState);
        return uri;
    }

    protected abstract void checkUri(@Nonnull URI var1, @Nonnull SrvEntryBasedServicesManager.State var2) throws Exception, ServiceTemporaryUnavailableException;

    @Nonnull
    protected URI toUri(@Nonnull URI original, @Nonnull InetSocketAddress address) {
        String scheme = original.getScheme();
        int port = address.getPort();
        String userInfo = original.getRawUserInfo();
        String path = original.getRawPath();
        String query = original.getRawQuery();
        String fragment = original.getRawFragment();
        StringBuilder sb = new StringBuilder();
        sb.append(scheme).append("://");
        if (StringUtils.isNotEmpty((CharSequence)userInfo)) {
            sb.append(userInfo).append('@');
        }
        sb.append(address.getHostString());
        if (this.canAppendPort(scheme, port)) {
            sb.append(':').append(port);
        }
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            sb.append(path);
        }
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            sb.append('?').append(query);
        }
        if (StringUtils.isNotEmpty((CharSequence)fragment)) {
            sb.append('#').append(fragment);
        }
        return URI.create(sb.toString());
    }

    protected boolean canAppendPort(@Nonnull String scheme, int port) {
        return "http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443;
    }
}

