/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.cache;

import javax.annotation.Nonnull;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.CacheUtils;
import org.echocat.jomon.cache.ClearableCache;
import org.echocat.jomon.cache.ClearableCacheListener;
import org.echocat.jomon.cache.IdentifiedCache;
import org.echocat.jomon.cache.LocalTrackingEnabledCacheListener;
import org.echocat.jomon.cache.management.CacheRepository;
import org.echocat.jomon.net.cluster.cache.CacheListenerForClusterChannelSupport;
import org.echocat.jomon.net.cluster.channel.HandlerEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.Message;
import org.echocat.jomon.net.cluster.channel.Node;
import org.echocat.jomon.net.cluster.channel.ReceivedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearOverClusterListener
extends CacheListenerForClusterChannelSupport
implements ClearableCacheListener {
    private static final Logger LOG = LoggerFactory.getLogger(ClearOverClusterListener.class);
    private final HandlerEnabledClusterChannel.MessageHandler _messageHandler = new HandlerEnabledClusterChannel.MessageHandler(){

        @Override
        public void handle(@Nonnull HandlerEnabledClusterChannel<?, ?> clusterChannel, @Nonnull ReceivedMessage<?> message) {
            if (message.getCommand() == -126) {
                String cacheId = message.getDataAsString(CacheListenerForClusterChannelSupport.CHARSET);
                ClearOverClusterListener.this.clear(cacheId, (Node<?>)message.getFrom());
            }
        }
    };

    public ClearOverClusterListener(@Nonnull CacheRepository cacheRepository, @Nonnull HandlerEnabledClusterChannel<?, ?> clusterChannel) {
        super(cacheRepository, clusterChannel);
    }

    @Override
    @Nonnull
    protected HandlerEnabledClusterChannel.MessageHandler getMessageHandler() {
        return this._messageHandler;
    }

    public void afterClear(@Nonnull Cache<?, ?> cache) {
        if (cache instanceof IdentifiedCache && !this.isPossibleEndlessLoop()) {
            String cacheId = ((IdentifiedCache)cache).getId();
            CacheUtils.assertValidCacheId((String)cacheId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Send clear for cache: " + cacheId, this.createThrowableIfLogStackTraceIsNeeded());
            }
            this.send(new Message(-126, cacheId, CHARSET));
            this.record(Event.afterClear);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear(@Nonnull String cacheId, @Nonnull Node<?> from) {
        Cache cache = this.findCache(cacheId);
        if (cache instanceof ClearableCache) {
            this.startHandleMessage();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received clear for cache: " + cacheId + " - from: " + from);
                }
                ((ClearableCache)cache).clear();
            }
            finally {
                this.finishHandleMessage();
            }
        }
    }

    public boolean beforeClear(@Nonnull Cache<?, ?> cache) {
        return true;
    }

    public static enum Event implements LocalTrackingEnabledCacheListener.Event
    {
        afterClear;

    }
}

