/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.cache;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.CacheUtils;
import org.echocat.jomon.cache.IdentifiedCache;
import org.echocat.jomon.cache.LocalTrackingEnabledCacheListener;
import org.echocat.jomon.cache.RemoveCacheListener;
import org.echocat.jomon.cache.management.CacheRepository;
import org.echocat.jomon.net.cluster.cache.CacheListenerForClusterChannelSupport;
import org.echocat.jomon.net.cluster.channel.HandlerEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.Message;
import org.echocat.jomon.net.cluster.channel.Node;
import org.echocat.jomon.net.cluster.channel.ReceivedMessage;
import org.echocat.jomon.runtime.util.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveOverClusterListener
extends CacheListenerForClusterChannelSupport
implements RemoveCacheListener {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveOverClusterListener.class);
    public static final String LOG_STACK_TRACE_PROPERTY_NAME = RemoveOverClusterListener.class.getName() + ".logStackTrace";
    private final HandlerEnabledClusterChannel.MessageHandler _messageHandler = new HandlerEnabledClusterChannel.MessageHandler(){

        @Override
        public void handle(@Nonnull HandlerEnabledClusterChannel<?, ?> clusterChannel, @Nonnull ReceivedMessage<?> message) {
            String removeMessage;
            int fistIndex;
            if (message.getCommand() == -127 && (fistIndex = (removeMessage = message.getDataAsString(CacheListenerForClusterChannelSupport.CHARSET)).indexOf(59)) >= 1 && fistIndex < removeMessage.length() + 1) {
                String cacheId = removeMessage.substring(0, fistIndex);
                String key = removeMessage.substring(fistIndex + 1);
                RemoveOverClusterListener.this.remove(cacheId, key, (Node<?>)message.getFrom());
            }
        }
    };

    public RemoveOverClusterListener(@Nonnull CacheRepository cacheRepository, @Nonnull HandlerEnabledClusterChannel<?, ?> clusterChannel) {
        super(cacheRepository, clusterChannel);
    }

    @Override
    @Nonnull
    protected HandlerEnabledClusterChannel.MessageHandler getMessageHandler() {
        return this._messageHandler;
    }

    public void afterRemove(@Nonnull Cache<?, ?> cache, @Nullable Object key, @Nullable Value<?> oldValue) {
        if (cache instanceof IdentifiedCache && key != null && !this.isPossibleEndlessLoop()) {
            if (key instanceof String || key instanceof Integer || key instanceof Long || key instanceof Boolean) {
                String cacheId = ((IdentifiedCache)cache).getId();
                CacheUtils.assertValidCacheId((String)cacheId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send remove for object: " + cacheId + "/" + key, this.createThrowableIfLogStackTraceIsNeeded());
                }
                this.send(new Message(-127, cacheId + ";" + key, CHARSET));
                this.record(Event.afterRemove);
            } else {
                LOG.warn("Could only handle key of type string. Invalid key was: " + key, this.createThrowableIfLogStackTraceIsNeeded());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(@Nonnull String cacheId, @Nonnull String key, @Nonnull Node<?> from) {
        Cache cache = this.findCache(cacheId);
        if (cache != null) {
            Object realKey;
            Class keyType = cache.getKeyType();
            if (Integer.class.equals((Object)keyType)) {
                realKey = Integer.valueOf(key);
            } else if (Long.class.equals((Object)keyType)) {
                realKey = Long.valueOf(key);
            } else if (Boolean.class.equals((Object)keyType)) {
                realKey = Boolean.TRUE.toString().equalsIgnoreCase(key);
            } else if (String.class.equals((Object)keyType)) {
                realKey = key;
            } else {
                throw new IllegalArgumentException("Could not handle key '" + key + "' for cache " + cache + ".");
            }
            this.startHandleMessage();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received remove for object: " + cacheId + "/" + realKey + " - from: " + from);
                }
                cache.remove(realKey);
            }
            finally {
                this.finishHandleMessage();
            }
        }
    }

    public boolean beforeRemove(@Nonnull Cache<?, ?> cache, @Nullable Object key) {
        return true;
    }

    public static enum Event implements LocalTrackingEnabledCacheListener.Event
    {
        afterRemove;

    }
}

