/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.cluster.channel.ClusterChannel;
import org.echocat.jomon.net.cluster.channel.Node;
import org.echocat.jomon.net.cluster.channel.StatisticEnabledNode;

public class ClusterChannelUtils {
    private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.US);

    @Nonnull
    public static String formatNodesStatusOf(@Nonnull ClusterChannel<?, ?> clusterChannel) {
        return ClusterChannelUtils.formatNodesStatusOf(clusterChannel.getNodes());
    }

    @Nonnull
    public static String formatNodesStatusOf(@Nonnull Iterable<? extends Node<?>> nodes) {
        StringBuilder sb = new StringBuilder();
        for (Node<?> node : nodes) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(node);
            if (!(node instanceof StatisticEnabledNode)) continue;
            StatisticEnabledNode statistic = (StatisticEnabledNode)node;
            Date lastSeen = statistic.getLastSeen();
            sb.append("{Last seen: ").append(lastSeen != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(lastSeen) : "never");
            ClusterChannelUtils.formatInbound(sb, statistic);
            ClusterChannelUtils.formatOutbound(sb, statistic);
            sb.append('}');
        }
        return sb.toString();
    }

    protected static void formatInbound(@Nonnull StringBuilder to, @Nonnull StatisticEnabledNode<?> of) {
        ClusterChannelUtils.formatDetails("Inbound", to, of.getLastInboundMessage(), of.getNumberOfInboundMessages(), of.getNumberOfInboundMessagesPerSecond());
    }

    protected static void formatOutbound(@Nonnull StringBuilder to, @Nonnull StatisticEnabledNode<?> of) {
        ClusterChannelUtils.formatDetails("Outbound", to, of.getLastOutboundMessage(), of.getNumberOfOutboundMessages(), of.getNumberOfOutboundMessagesPerSecond());
    }

    protected static void formatDetails(@Nonnull String prefix, @Nonnull StringBuilder to, @Nullable Date lastMessage, @Nullable Long numberOfMessages, @Nullable Double numberOfMessagesPerSecond) {
        if (lastMessage != null || numberOfMessages != null || numberOfMessagesPerSecond != null) {
            to.append(" / ").append(prefix).append(": ");
            if (numberOfMessages != null) {
                to.append(new DecimalFormat("#,##0", SYMBOLS).format(numberOfMessages)).append(" total");
            }
            if (numberOfMessagesPerSecond != null) {
                if (numberOfMessages != null) {
                    to.append(", ");
                }
                to.append(new DecimalFormat("#,##0.00", SYMBOLS).format(numberOfMessagesPerSecond)).append(" m/s");
            }
            if (lastMessage != null && (numberOfMessages != null || numberOfMessagesPerSecond != null)) {
                to.append(", ");
            }
            to.append("last at ").append(lastMessage != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(lastMessage) : "never");
        }
    }

    private ClusterChannelUtils() {
    }
}

