/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel;

import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Hex;

public class Message {
    private final byte _command;
    private final byte[] _data;
    private final int _offset;
    private final int _length;

    public Message(byte command, @Nonnull String data, @Nonnull Charset charset) {
        this(command, data.getBytes(charset));
    }

    public Message(byte command, @Nonnull byte[] data) {
        this(command, data, data.length);
    }

    public Message(byte command, @Nonnull byte[] data, @Nonnegative int length) {
        this(command, data, 0, length);
    }

    public Message(byte command, @Nonnull byte[] data, @Nonnegative int offset, @Nonnegative int length) {
        if (offset < 0 || length < offset) {
            throw new IllegalArgumentException();
        }
        if (offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._command = command;
        this._data = data;
        this._offset = offset;
        this._length = length;
    }

    public byte getCommand() {
        return this._command;
    }

    @Nonnull
    public byte[] getData() {
        return this._data;
    }

    @Nonnegative
    public int getOffset() {
        return this._offset;
    }

    @Nonnegative
    public int getLength() {
        return this._length;
    }

    @Nonnull
    public String getDataAsString(@Nonnull Charset charset) {
        return new String(this._data, this._offset, this._length, charset);
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof Message)) {
            result = false;
        } else {
            Message that = (Message)o;
            result = this.getCommand() == that.getCommand() && Arrays.equals(this.getData(), that.getData()) && this.getOffset() == that.getOffset() && this.getLength() == that.getLength();
        }
        return result;
    }

    public int hashCode() {
        int result = this.getCommand();
        result = 31 * result + Arrays.hashCode(this.getData());
        result = 31 * result + this.getOffset();
        result = 31 * result + this.getLength();
        return result;
    }

    public String toString() {
        int length = this.getLength();
        int offset = this.getOffset();
        char[] trimmedData = Hex.encodeHex((byte[])Arrays.copyOfRange(this.getData(), offset, offset + (length > 80 ? 80 : length)), (boolean)false);
        return this.getCommand() + -127 + ":" + trimmedData + (length > 80 ? "..." : "");
    }
}

