/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel;

import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Node<ID> {
    public static final Comparator<Node<?>> ADDRESS_BASED_COMPARATOR = new Comparator<Node<?>>(){

        @Override
        public int compare(Node<?> o1, Node<?> o2) {
            int result;
            if (o1 == null && o2 == null) {
                result = 0;
            } else if (o1 != null) {
                result = 1;
            } else if (o2 != null) {
                result = -1;
            } else {
                InetSocketAddress a1 = o1.getAddress();
                InetSocketAddress a2 = o2.getAddress();
                result = a1 == null && a2 == null ? 0 : (a1 != null ? 1 : (a2 != null ? -1 : a1.toString().compareTo(a2.toString())));
            }
            return result;
        }
    };

    @Nonnull
    public ID getId();

    @Nonnull
    public UUID getUuid();

    @Nonnull
    public InetSocketAddress getAddress();

    @Nullable
    public Date getLastSeen();

    public static abstract class Impl<ID>
    implements Node<ID> {
        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof Impl)) {
                result = false;
            } else {
                Node that = (Node)o;
                result = this.getUuid().equals(that.getUuid());
            }
            return result;
        }

        public int hashCode() {
            return this.getUuid().hashCode();
        }

        public String toString() {
            return this.getId() + ":" + this.getAddress();
        }
    }
}

