/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel;

import java.util.Date;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.echocat.jomon.net.cluster.channel.Node;
import org.echocat.jomon.runtime.math.OverPeriodCounter;
import org.echocat.jomon.runtime.util.Duration;

public interface StatisticEnabledNode<ID>
extends Node<ID> {
    @Nullable
    public Boolean getIsInboundConnected();

    @Nonnegative
    @Nullable
    public Long getNumberOfInboundMessages();

    @Nonnegative
    @Nullable
    public Double getNumberOfInboundMessagesPerSecond();

    @Nullable
    public Date getLastInboundMessage();

    @Nullable
    public Boolean getIsOutboundConnected();

    @Nonnegative
    @Nullable
    public Long getNumberOfOutboundMessages();

    @Nonnegative
    @Nullable
    public Double getNumberOfOutboundMessagesPerSecond();

    @Nullable
    public Date getLastOutboundMessage();

    public static abstract class Impl<ID>
    extends Node.Impl<ID>
    implements StatisticEnabledNode<ID> {
        private final OverPeriodCounter _numberOfInboundMessagesPerSecond = new OverPeriodCounter(new Duration("1m"), new Duration("1s"));
        private volatile long _numberOfInboundMessages;
        private volatile long _lastInboundMessageInMillis;
        private final OverPeriodCounter _numberOfOutboundMessagesPerSecond = new OverPeriodCounter(new Duration("1m"), new Duration("1s"));
        private volatile long _numberOfOutboundMessages;
        private volatile long _lastOutboundMessageInMillis;
        private volatile long _lastSeenInMillis;

        @Nonnegative
        public long getLastSeenInMillis() {
            return this._lastSeenInMillis;
        }

        @Override
        @Nullable
        public Date getLastSeen() {
            long lastSeenInMillis = this.getLastSeenInMillis();
            return lastSeenInMillis > 0L ? new Date(lastSeenInMillis) : null;
        }

        public void recordVitalSign() {
            this._lastSeenInMillis = System.currentTimeMillis();
        }

        @Override
        @Nullable
        public Boolean getIsInboundConnected() {
            return null;
        }

        @Override
        @Nonnegative
        public Double getNumberOfInboundMessagesPerSecond() {
            return this._numberOfInboundMessagesPerSecond.getAsDouble();
        }

        @Nonnegative
        public long getLastInboundMessageInMillis() {
            return this._lastInboundMessageInMillis;
        }

        @Override
        @Nullable
        public Date getLastInboundMessage() {
            long lastInboundMessageInMillis = this.getLastInboundMessageInMillis();
            return lastInboundMessageInMillis > 0L ? new Date(lastInboundMessageInMillis) : null;
        }

        @Override
        @Nonnegative
        @Nullable
        public Long getNumberOfInboundMessages() {
            return this._numberOfInboundMessages;
        }

        public void recordInbound() {
            long millis;
            this._numberOfInboundMessagesPerSecond.record();
            ++this._numberOfInboundMessages;
            this._lastInboundMessageInMillis = millis = System.currentTimeMillis();
            this._lastSeenInMillis = millis;
        }

        @Override
        @Nullable
        public Boolean getIsOutboundConnected() {
            return null;
        }

        @Override
        @Nonnegative
        @Nullable
        public Double getNumberOfOutboundMessagesPerSecond() {
            return this._numberOfOutboundMessagesPerSecond.getAsDouble();
        }

        @Nonnegative
        public long getLastOutboundMessageInMillis() {
            return this._lastOutboundMessageInMillis;
        }

        @Override
        @Nullable
        public Date getLastOutboundMessage() {
            long lastOutboundMessageInMillis = this.getLastOutboundMessageInMillis();
            return lastOutboundMessageInMillis > 0L ? new Date(lastOutboundMessageInMillis) : null;
        }

        @Override
        @Nonnegative
        @Nullable
        public Long getNumberOfOutboundMessages() {
            return this._numberOfOutboundMessages;
        }

        public void recordOutbound() {
            this._numberOfOutboundMessagesPerSecond.record();
            ++this._numberOfOutboundMessages;
            this._lastOutboundMessageInMillis = System.currentTimeMillis();
        }
    }
}

