/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.cluster.channel.AddressEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.ByteUtils;
import org.echocat.jomon.net.cluster.channel.HandlerEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.Message;
import org.echocat.jomon.net.cluster.channel.NetBasedClusterChannel;
import org.echocat.jomon.net.cluster.channel.Node;
import org.echocat.jomon.net.cluster.channel.ReceivedMessage;
import org.echocat.jomon.net.cluster.channel.SendingQueueEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.multicast.MulticastNode;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.GotInterruptedException;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastClusterChannel
extends NetBasedClusterChannel<Short, MulticastNode>
implements AddressEnabledClusterChannel<Short, MulticastNode>,
SendingQueueEnabledClusterChannel<Short, MulticastNode> {
    private static final Logger LOG = LoggerFactory.getLogger(MulticastClusterChannel.class);
    private static final int BUFFER_SIZE = 1024;
    private static final Random RANDOM = new SecureRandom();
    private BlockingDeque<Message> _messageQueue = new LinkedBlockingDeque<Message>(10000);
    private final Map<Short, MulticastNode> _idToNode = new ConcurrentHashMap<Short, MulticastNode>();
    private volatile Collection<MulticastNode> _nodes;
    private final Reader _reader = new Reader();
    private final Writer _writer = new Writer();
    private final NetBasedClusterChannel.Pinger _pinger = new NetBasedClusterChannel.Pinger();
    @Nullable
    private volatile InetSocketAddress _address;
    @Nullable
    private volatile NetworkInterface _networkInterface;
    @Nonnull
    private Duration _ttl = new Duration("10s");
    @Nonnegative
    private double _pingIntervalToTimeoutRatio = 2.5;
    @Nullable
    private Thread _writingThread;
    @Nullable
    private Thread _readingThread;
    @Nullable
    private Thread _pingingThread;
    @Nullable
    private volatile MulticastSocket _out;
    @Nullable
    private volatile MulticastSocket _in;
    private volatile short _id;

    public MulticastClusterChannel() {
        this.setSoTimeout(new Duration("1s"));
    }

    public MulticastClusterChannel(@Nullable UUID uuid) {
        super(uuid);
        this.setSoTimeout(new Duration("1s"));
    }

    @Override
    public InetSocketAddress getAddress() {
        return this._address;
    }

    @Override
    public void setAddress(final @Nullable InetSocketAddress address) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() {
                MulticastClusterChannel.this._address = address;
                return null;
            }
        });
    }

    @Override
    public void setAddress(final @Nullable InetSocketAddress address, final @Nullable NetworkInterface networkInterface) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() {
                MulticastClusterChannel.this._address = address;
                MulticastClusterChannel.this._networkInterface = networkInterface;
                return null;
            }
        });
    }

    @Override
    public NetworkInterface getInterface() {
        return this._networkInterface;
    }

    @Override
    public void setInterface(final @Nullable NetworkInterface networkInterface) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() {
                MulticastClusterChannel.this._networkInterface = networkInterface;
                return null;
            }
        });
    }

    @Override
    public int getSendingQueueCapacity() {
        return this._messageQueue.remainingCapacity() + this._messageQueue.size();
    }

    @Override
    public void setSendingQueueCapacity(final @Nonnegative int capacity) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() {
                MulticastClusterChannel.this._messageQueue = new LinkedBlockingDeque(capacity > 0 ? capacity : 1);
                return null;
            }
        });
    }

    @Nonnull
    public Duration getTtl() {
        return this._ttl;
    }

    public void setTtl(@Nonnull Duration ttl) {
        if (ttl == null) {
            throw new NullPointerException();
        }
        this._ttl = ttl;
    }

    @Nonnegative
    public final double getPingIntervalToTimeoutRatio() {
        return this._pingIntervalToTimeoutRatio;
    }

    public final void setPingIntervalToTimeoutRatio(@Nonnegative double pingIntervalToTimeoutRatio) {
        if (pingIntervalToTimeoutRatio <= 0.0) {
            throw new IllegalArgumentException();
        }
        this._pingIntervalToTimeoutRatio = pingIntervalToTimeoutRatio;
    }

    @Override
    protected void initInLock() throws Exception {
        super.initInLock();
        this._pingingThread = new Thread((Runnable)this._pinger, this.toString() + ".Pinger");
        this._pingingThread.setDaemon(true);
        this._readingThread = new Thread((Runnable)this._reader, this.toString() + ".Reader");
        this._readingThread.setDaemon(true);
        this._writingThread = new Thread((Runnable)this._writer, this.toString() + ".Writer");
        this._writingThread.setDaemon(true);
        this._pingingThread.start();
        this._readingThread.start();
        this._writingThread.start();
    }

    @Override
    protected void closeBeforeLock() throws Exception {
        super.closeBeforeLock();
        this.closeIn();
        this.closeOut();
        ThreadUtils.stop((Thread)this._pingingThread);
        ThreadUtils.stop((Thread)this._writingThread);
        ThreadUtils.stop((Thread)this._readingThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeInLock() throws Exception {
        super.closeInLock();
        try {
            try {
                try {
                    try {
                        ThreadUtils.stop((Thread)this._pingingThread);
                    }
                    finally {
                        this._pingingThread = null;
                    }
                }
                finally {
                    try {
                        ThreadUtils.stop((Thread)this._writingThread);
                    }
                    finally {
                        this._writingThread = null;
                    }
                }
            }
            finally {
                try {
                    ThreadUtils.stop((Thread)this._readingThread);
                }
                finally {
                    this._readingThread = null;
                }
            }
        }
        finally {
            try {
                this.closeIn();
            }
            finally {
                this.closeOut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeIn() {
        try {
            try {
                InetSocketAddress address = this._address;
                NetworkInterface networkInterface = this._networkInterface;
                if (address != null) {
                    try {
                        this._in.leaveGroup(address, networkInterface);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                ResourceUtils.closeQuietly((AutoCloseable)this._in);
            }
        }
        finally {
            this._in = null;
        }
    }

    protected void closeOut() {
        try {
            ResourceUtils.closeQuietly((AutoCloseable)this._out);
        }
        finally {
            this._out = null;
        }
    }

    @Nullable
    protected DatagramSocket getOut() throws IOException, InterruptedException {
        this.getLock().lockInterruptibly();
        try {
            if (this._out == null) {
                this._out = new MulticastSocket();
                this._out.setTimeToLive((int)this._ttl.in(TimeUnit.SECONDS));
                this._out.setSoTimeout((int)this.getSoTimeout().in(TimeUnit.MILLISECONDS));
            }
            MulticastSocket multicastSocket = this._out != null && !this._out.isClosed() ? this._out : null;
            return multicastSocket;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Nullable
    protected DatagramSocket getIn() throws IOException, InterruptedException {
        this.getLock().lockInterruptibly();
        try {
            if (this._in == null) {
                InetSocketAddress address = this._address;
                NetworkInterface networkInterface = this._networkInterface;
                if (address != null) {
                    this._in = new MulticastSocket(address.getPort());
                    this._in.joinGroup(address, networkInterface);
                    this._in.setTimeToLive((int)this._ttl.in(TimeUnit.SECONDS));
                    this._in.setSoTimeout((int)this.getSoTimeout().in(TimeUnit.MILLISECONDS));
                } else {
                    this._in = null;
                }
            }
            MulticastSocket multicastSocket = this._in != null && !this._in.isClosed() ? this._in : null;
            return multicastSocket;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public boolean isConnected() {
        return this._address != null && this._readingThread != null && this._writingThread != null;
    }

    @Override
    @Nonnull
    public MulticastNode getLocalNode() {
        return new MulticastNode(this._id, this.getUuid(), this._address);
    }

    @Override
    public void send(@Nonnull Message message) {
        try {
            this._messageQueue.put(message);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            throw new GotInterruptedException();
        }
    }

    @Override
    public void send(@Nonnull Message message, @Nonnegative long timeout, @Nonnull TimeUnit unit) {
        try {
            this._messageQueue.offer(message, timeout, unit);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    protected void sendInternal(@Nonnegative short id, @Nonnull Message message) throws IOException, InterruptedException {
        block3: {
            DatagramPacket packet;
            DatagramSocket out = this.getOut();
            if (out != null && (packet = this.toPacket(id, message)) != null) {
                try {
                    out.send(packet);
                    this.recordMessageSend();
                }
                catch (SocketException e) {
                    String messageOfException = e.getMessage();
                    if (messageOfException != null || messageOfException.equalsIgnoreCase("socket closed")) break block3;
                    throw e;
                }
            }
        }
    }

    protected void sendPing(@Nonnegative short id) throws IOException, InterruptedException {
        byte[] payload = new byte[16];
        UUID uuid = this.getUuid();
        ByteUtils.putLong(payload, 0, uuid.getMostSignificantBits());
        ByteUtils.putLong(payload, 8, uuid.getLeastSignificantBits());
        this.sendInternal(id, new Message(-128, payload));
        this.recordPingSend();
    }

    @Nonnegative
    protected short getId(boolean forceSendPing) throws IOException, InterruptedException {
        short id = this._id;
        for (int i = 0; i < 100 && id <= 0; ++i) {
            byte[] bytes = new byte[2];
            RANDOM.nextBytes(bytes);
            id = ByteUtils.getShort(bytes, 0);
        }
        if (id <= 0) {
            throw new IllegalStateException("It was not possible to retrieve an id in 100 tries.");
        }
        if (forceSendPing || id != this._id || this.isPingRequired()) {
            this.sendPing(id);
        }
        if (id != this._id) {
            this._id = id;
            LOG.info("Registered myself with id #" + id + " in the cluster.");
        }
        return id;
    }

    @Nullable
    protected DatagramPacket toPacket(@Nonnegative short id, @Nonnull Message message) throws SocketException {
        DatagramPacket packet;
        InetSocketAddress address = this._address;
        if (address != null) {
            if (message.getLength() <= 1021) {
                byte[] payload = new byte[message.getLength() + 3];
                payload[0] = message.getCommand();
                ByteUtils.putShort(payload, 1, id);
                System.arraycopy(message.getData(), message.getOffset(), payload, 3, message.getLength());
                packet = new DatagramPacket(payload, payload.length, address);
            } else {
                packet = null;
                LOG.warn("It was not possible to send '" + message + "' because it reached the limit of " + 1021 + " bytes for each packet. This message will be ignored.");
            }
        } else {
            packet = null;
        }
        return packet;
    }

    protected void readFrom(@Nonnull DatagramSocket in) throws IOException {
        block4: {
            byte[] buffer = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                in.receive(packet);
                ReceivedMessage<MulticastNode> message = this.toReceivedMessage(packet);
                if (message != null) {
                    message.getFrom().recordOutbound();
                    this.read(message);
                }
            }
            catch (SocketTimeoutException message) {
            }
            catch (SocketException e) {
                String message = e.getMessage();
                if (message != null || message.equalsIgnoreCase("socket closed")) break block4;
                throw e;
            }
        }
    }

    @Nullable
    protected ReceivedMessage<MulticastNode> toReceivedMessage(@Nonnull DatagramPacket packet) throws SocketException {
        ReceivedMessage<MulticastNode> message;
        int length = packet.getLength();
        if (length >= 3) {
            int offset = packet.getOffset();
            byte[] data = packet.getData();
            byte command = data[offset];
            short remoteId = ByteUtils.getShort(data, offset + 1);
            byte[] messageData = length >= 4 ? Arrays.copyOfRange(data, offset + 3, offset + length) : new byte[]{};
            MulticastNode node = this.toNode(command, remoteId, messageData, packet);
            message = node != null ? new ReceivedMessage<MulticastNode>(command, messageData, node) : null;
        } else {
            message = null;
        }
        return message;
    }

    @Nullable
    protected MulticastNode toNode(byte command, short remoteId, @Nonnull byte[] messageData, @Nullable DatagramPacket packet) {
        SocketAddress address = packet.getSocketAddress();
        return this.toNode(command, remoteId, messageData, address);
    }

    @Nullable
    protected MulticastNode toNode(byte command, short remoteId, @Nonnull byte[] messageData, @Nullable SocketAddress address) {
        return this.toNode(command, remoteId, messageData, address instanceof InetSocketAddress ? (InetSocketAddress)address : null);
    }

    @Nullable
    protected MulticastNode toNode(byte command, short remoteId, @Nonnull byte[] messageData, @Nullable InetSocketAddress socketAddress) {
        MulticastNode node;
        if (command == -128) {
            if (messageData.length == 16) {
                UUID uuid = new UUID(ByteUtils.getLong(messageData, 0), ByteUtils.getLong(messageData, 8));
                node = new MulticastNode(remoteId, uuid, socketAddress);
                node.recordVitalSign();
            } else {
                node = null;
            }
        } else {
            MulticastNode potentialNode;
            MulticastNode multicastNode = potentialNode = remoteId != this._id ? this.findNodeBy(remoteId) : null;
            if (potentialNode != null && potentialNode.getId() == remoteId) {
                InetAddress address;
                InetSocketAddress potentialSocketAddress = potentialNode.getAddress();
                InetAddress potentialAddress = potentialSocketAddress != null ? potentialSocketAddress.getAddress() : null;
                InetAddress inetAddress = address = socketAddress != null ? socketAddress.getAddress() : null;
                if (address != null ? address.equals(potentialAddress) : potentialAddress == null) {
                    node = potentialNode;
                    potentialNode.recordInbound();
                } else {
                    node = null;
                }
            } else {
                node = null;
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private MulticastNode findNodeBy(short remoteId) {
        Map<Short, MulticastNode> map = this._idToNode;
        synchronized (map) {
            return this._idToNode.get(remoteId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readPing(@Nonnull ReceivedMessage<MulticastNode> message) {
        Map<Short, MulticastNode> map = this._idToNode;
        synchronized (map) {
            MulticastNode node = message.getFrom();
            if (!node.getUuid().equals(this.getUuid())) {
                MulticastNode current = this._idToNode.get(node.getId());
                if (current != null && current.equals(node)) {
                    current.recordVitalSign();
                } else {
                    this._idToNode.put(node.getId(), node);
                    LOG.info("Node " + node + " entered the cluster.");
                    for (HandlerEnabledClusterChannel.Handler handler : this.getHandlers()) {
                        if (!(handler instanceof HandlerEnabledClusterChannel.PresenceHandler)) continue;
                        ((HandlerEnabledClusterChannel.PresenceHandler)handler).nodeEnter(this, current);
                    }
                }
                if (node != null && node.getId() == this._id) {
                    this._id = 0;
                }
            }
        }
    }

    @Override
    @Nonnegative
    public Integer getSendingQueueSize() {
        return this._messageQueue.size();
    }

    @Override
    @Nonnegative
    @Nonnull
    public Short getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void cleanUpNodes() {
        long expiresAt = System.currentTimeMillis() - (long)((double)this.getPingInterval().in(TimeUnit.MILLISECONDS) * this._pingIntervalToTimeoutRatio);
        Map<Short, MulticastNode> map = this._idToNode;
        synchronized (map) {
            Iterator<MulticastNode> i = this._idToNode.values().iterator();
            while (i.hasNext()) {
                MulticastNode node = i.next();
                if (node.getLastSeenInMillis() > expiresAt) continue;
                i.remove();
                LOG.info("Node " + node + " left the cluster. (Timeout)");
                for (HandlerEnabledClusterChannel.Handler handler : this.getHandlers()) {
                    if (!(handler instanceof HandlerEnabledClusterChannel.PresenceHandler)) continue;
                    ((HandlerEnabledClusterChannel.PresenceHandler)handler).nodeLeft(this, node);
                }
            }
            this._nodes = this._idToNode.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final Set<MulticastNode> getNodes() {
        TreeSet result = new TreeSet(Node.ADDRESS_BASED_COMPARATOR);
        Map<Short, MulticastNode> map = this._idToNode;
        synchronized (map) {
            result.addAll(this._idToNode.values());
        }
        return result;
    }

    @Override
    public final void ping() {
        this.cleanUpNodes();
        try {
            this.getId(true);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not send ping.", e);
        }
    }

    @Override
    protected void recordMessageSend() {
        super.recordMessageSend();
        Collection<MulticastNode> nodes = this._nodes;
        if (nodes != null) {
            for (MulticastNode node : nodes) {
                node.recordOutbound();
            }
        }
    }

    @Nullable
    protected String getNetworkInterfaceSuffix() {
        NetworkInterface networkInterface = this._networkInterface;
        return networkInterface != null ? "@" + networkInterface.getName() : "";
    }

    public String toString() {
        InetSocketAddress address;
        String name = this.getName();
        String result = name != null ? name : ((address = this._address) != null ? address + this.getNetworkInterfaceSuffix() : "<offline>");
        return result;
    }

    protected class Reader
    implements Runnable {
        protected Reader() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        DatagramSocket in = MulticastClusterChannel.this.getIn();
                        if (in != null) {
                            MulticastClusterChannel.this.readFrom(in);
                            continue;
                        }
                        Thread.sleep(1000L);
                    }
                    catch (IOException e) {
                        LOG.warn("Could not read message from " + MulticastClusterChannel.this._address + MulticastClusterChannel.this.getNetworkInterfaceSuffix() + ".", (Throwable)e);
                    }
                }
                return;
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected class Writer
    implements Runnable {
        protected Writer() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Message message = (Message)MulticastClusterChannel.this._messageQueue.take();
                        try {
                            short id = MulticastClusterChannel.this.getId(false);
                            MulticastClusterChannel.this.sendInternal(id, message);
                            continue block4;
                        }
                        catch (IOException e) {
                            LOG.warn("Could not write message '" + message + "' to " + MulticastClusterChannel.this._address + MulticastClusterChannel.this.getNetworkInterfaceSuffix() + ". This message is lost.", (Throwable)e);
                        }
                    }
                    break;
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }
}

