/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel.tcp;

import java.net.InetSocketAddress;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.cluster.channel.Node;
import org.echocat.jomon.net.cluster.channel.tcp.InboundTcpNode;
import org.echocat.jomon.net.cluster.channel.tcp.OutboundTcpNode;
import org.echocat.jomon.net.cluster.channel.tcp.TcpNode;

public class TcpNodeInfo
extends Node.Impl<UUID>
implements TcpNode {
    private final UUID _uuid;
    private final InetSocketAddress _address;
    private InboundTcpNode _inbound;
    private OutboundTcpNode _outbound;

    public TcpNodeInfo(@Nonnull UUID uuid, @Nonnull InetSocketAddress address) {
        this._uuid = uuid;
        this._address = address;
    }

    @Override
    @Nonnull
    public UUID getId() {
        return this.getUuid();
    }

    @Override
    @Nonnull
    public UUID getUuid() {
        return this._uuid;
    }

    @Override
    @Nonnull
    public InetSocketAddress getAddress() {
        return this._address;
    }

    public InboundTcpNode getInbound() {
        return this._inbound;
    }

    public void setInbound(InboundTcpNode inbound) {
        this._inbound = inbound;
    }

    public OutboundTcpNode getOutbound() {
        return this._outbound;
    }

    public void setOutbound(OutboundTcpNode outbound) {
        this._outbound = outbound;
    }

    @Override
    @Nullable
    public Date getLastSeen() {
        Date outboundLastSeen;
        InboundTcpNode inbound = this._inbound;
        OutboundTcpNode outbound = this._outbound;
        Date inboundLastSeen = inbound != null ? inbound.getLastSeen() : null;
        Date date = outboundLastSeen = outbound != null ? outbound.getLastSeen() : null;
        Date result = inboundLastSeen == null && outboundLastSeen == null ? null : (inboundLastSeen != null && outboundLastSeen == null ? inboundLastSeen : (outboundLastSeen != null && inboundLastSeen == null ? outboundLastSeen : (inboundLastSeen.after(outboundLastSeen) ? inboundLastSeen : outboundLastSeen)));
        return result;
    }

    @Override
    public Boolean getIsInboundConnected() {
        InboundTcpNode inbound = this._inbound;
        return inbound != null && inbound.isConnected();
    }

    @Override
    public Long getNumberOfInboundMessages() {
        InboundTcpNode inbound = this._inbound;
        return inbound != null ? inbound.getNumberOfInboundMessages() : null;
    }

    @Override
    public Double getNumberOfInboundMessagesPerSecond() {
        InboundTcpNode inbound = this._inbound;
        return inbound != null ? inbound.getNumberOfInboundMessagesPerSecond() : null;
    }

    @Override
    public Date getLastInboundMessage() {
        InboundTcpNode inbound = this._inbound;
        return inbound != null ? inbound.getLastInboundMessage() : null;
    }

    @Override
    public Boolean getIsOutboundConnected() {
        OutboundTcpNode outbound = this._outbound;
        return outbound != null && outbound.isConnected();
    }

    @Override
    public Long getNumberOfOutboundMessages() {
        OutboundTcpNode outbound = this._outbound;
        return outbound != null ? outbound.getNumberOfOutboundMessages() : null;
    }

    @Override
    public Double getNumberOfOutboundMessagesPerSecond() {
        OutboundTcpNode outbound = this._outbound;
        return outbound != null ? outbound.getNumberOfOutboundMessagesPerSecond() : null;
    }

    @Override
    public Date getLastOutboundMessage() {
        OutboundTcpNode outbound = this._outbound;
        return outbound != null ? outbound.getLastOutboundMessage() : null;
    }
}

