/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.maven;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.echocat.jomon.maven.MavenEnvironment;
import org.sonatype.aether.RepositorySystemSession;

public class MavenEnvironmentFactory {
    @Nonnull
    public MavenEnvironment create() throws Exception {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        Class<?> cliRequestClass = this.getCliRequestClass();
        Object cliRequest = this.createCliRequest(classWorld, cliRequestClass);
        MavenExecutionRequest request = this.getRequestOf(cliRequest);
        AtomicReference<PlexusContainer> containerReference = new AtomicReference<PlexusContainer>();
        AtomicReference<DefaultMaven> oldMaven = new AtomicReference<DefaultMaven>();
        DefaultMavenExecutionResult executionResult = new DefaultMavenExecutionResult();
        Integer result = this.invokeCli(cliRequestClass, cliRequest, containerReference, oldMaven, executionResult);
        if (!new Integer(0).equals(result)) {
            throw new RuntimeException("Error while initiating the maven context. See message above.");
        }
        MavenExecutionRequest resultRequest = this.warpExecutionRequest(request, containerReference.get());
        RepositorySystemSession repositorySystemSession = this.createRepositorySystemSession(oldMaven.get(), resultRequest);
        this.injectDefaults(request, containerReference, repositorySystemSession, executionResult);
        return new MavenEnvironment((DefaultPlexusContainer)containerReference.get(), resultRequest, repositorySystemSession);
    }

    @Nonnull
    protected Class<?> getCliRequestClass() throws ClassNotFoundException {
        return MavenCli.class.getClassLoader().loadClass(MavenCli.class.getName() + "$CliRequest");
    }

    @Nonnull
    protected Object createCliRequest(@Nonnull ClassWorld classWorld, @Nonnull Class<?> cliRequestClass) throws Exception {
        Constructor<?> constructor = cliRequestClass.getDeclaredConstructor(String[].class, ClassWorld.class);
        constructor.setAccessible(true);
        return constructor.newInstance(new String[0], classWorld);
    }

    @Nonnull
    protected MavenExecutionRequest getRequestOf(@Nonnull Object cliRequest) throws Exception {
        Field requestField = cliRequest.getClass().getDeclaredField("request");
        requestField.setAccessible(true);
        return (MavenExecutionRequest)requestField.get(cliRequest);
    }

    @Nonnull
    protected Integer invokeCli(@Nonnull Class<?> cliRequestClass, @Nonnull Object cliRequest, @Nonnull AtomicReference<PlexusContainer> containerReference, @Nonnull AtomicReference<DefaultMaven> oldMaven, @Nonnull DefaultMavenExecutionResult executionResult) throws Exception {
        Maven maven = this.toMaven(executionResult);
        MavenCli cli = this.createCli(containerReference, oldMaven, maven);
        return (Integer)MavenCli.class.getMethod("doMain", cliRequestClass).invoke((Object)cli, cliRequest);
    }

    @Nonnull
    protected MavenCli createCli(final @Nonnull AtomicReference<PlexusContainer> containerReference, final @Nonnull AtomicReference<DefaultMaven> oldMaven, final Maven maven) {
        return new MavenCli(){

            protected void customizeContainer(PlexusContainer container) {
                try {
                    oldMaven.set((DefaultMaven)container.lookup(Maven.class));
                }
                catch (ComponentLookupException e) {
                    throw new RuntimeException(e);
                }
                container.addComponent((Object)maven, Maven.class, "");
                containerReference.set(container);
            }
        };
    }

    @Nonnull
    protected Maven toMaven(final @Nonnull DefaultMavenExecutionResult executionResult) {
        return new Maven(){

            public MavenExecutionResult execute(MavenExecutionRequest request) {
                return executionResult;
            }
        };
    }

    @Nonnull
    protected void injectDefaults(@Nonnull MavenExecutionRequest request, @Nonnull AtomicReference<PlexusContainer> containerReference, @Nonnull RepositorySystemSession repositorySystemSession, @Nonnull DefaultMavenExecutionResult executionResult) throws Exception {
        MavenSession session = new MavenSession(containerReference.get(), repositorySystemSession, request, (MavenExecutionResult)executionResult);
        LegacySupport legacySupport = (LegacySupport)containerReference.get().lookup(LegacySupport.class);
        legacySupport.setSession(session);
    }

    @Nonnull
    protected MavenExecutionRequest warpExecutionRequest(@Nonnull MavenExecutionRequest request, @Nonnull PlexusContainer container) throws ComponentLookupException, MavenExecutionRequestPopulationException {
        MavenExecutionRequestPopulator populator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
        return populator.populateDefaults(request);
    }

    @Nonnull
    protected RepositorySystemSession createRepositorySystemSession(@Nonnull DefaultMaven maven, @Nonnull MavenExecutionRequest resultRequest) {
        RepositorySystemSession repositorySystemSession = maven.newRepositorySession(resultRequest);
        resultRequest.getProjectBuildingRequest().setRepositorySession(repositorySystemSession);
        return repositorySystemSession;
    }
}

