/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.maven;

import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.collections15.map.LRUMap;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.echocat.jomon.maven.MavenEnvironment;
import org.echocat.jomon.maven.MavenEnvironmentFactory;
import org.echocat.jomon.maven.MavenProjectWithModules;
import org.echocat.jomon.maven.MavenProjectWithModulesFactory;
import org.echocat.jomon.runtime.system.DynamicClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.CollectionUtils;

public class OverwriteWithMavenResourcesClassLoader
extends ClassLoader
implements PriorityOrdered,
DynamicClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(OverwriteWithMavenResourcesClassLoader.class);
    private static final Map<Set<File>, Collection<File>> ROOT_POMS_RESOURCE_ROOT_CACHE = Collections.synchronizedMap(new LRUMap(10));
    private final Map<String, CacheEntry> _resourceCache = Collections.synchronizedMap(new LRUMap(1000));
    private Collection<File> _rootPoms;
    private boolean _setAsContextLoader;
    private boolean _useJvmWideCaching;
    private volatile Collection<File> _resourceRoots;

    public OverwriteWithMavenResourcesClassLoader(@Nonnull ClassLoader delegate) {
        super(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        OverwriteWithMavenResourcesClassLoader overwriteWithMavenResourcesClassLoader = this;
        synchronized (overwriteWithMavenResourcesClassLoader) {
            Collection<File> rootPoms = this._rootPoms;
            if (!CollectionUtils.isEmpty(rootPoms)) {
                HashSet<File> rootPomsAsCacheKey = new HashSet<File>(rootPoms);
                this._resourceRoots = ROOT_POMS_RESOURCE_ROOT_CACHE.get(rootPomsAsCacheKey);
                if (this._resourceRoots == null || !this._useJvmWideCaching) {
                    LOG.info("Found root poms " + rootPoms + ". Start to scan for usable resource roots...");
                    List<MavenProjectWithModules> projects = this.toProjectsRecursively(rootPoms);
                    this._resourceRoots = this.toResourceRoots(projects);
                    ROOT_POMS_RESOURCE_ROOT_CACHE.put(rootPomsAsCacheKey, rootPoms);
                    LOG.info("Found root poms " + rootPoms + ". Start to scan for usable resource roots... DONE!");
                }
            } else {
                this._resourceRoots = null;
            }
            if (this._resourceRoots != null && !this._resourceRoots.isEmpty()) {
                System.setProperty("org.apache.jasper.options.development", "true");
                System.setProperty("org.apache.jasper.options.checkInterval", "1");
            }
        }
        if (this._setAsContextLoader) {
            Thread.currentThread().setContextClassLoader(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(@Nonnull String name) {
        CacheEntry result;
        OverwriteWithMavenResourcesClassLoader overwriteWithMavenResourcesClassLoader = this;
        synchronized (overwriteWithMavenResourcesClassLoader) {
            result = this._resourceCache.get(name);
        }
        if (result == null) {
            Collection<File> resourceRoots = this._resourceRoots;
            File resultFile = null;
            if (resourceRoots != null) {
                if (resultFile != null && !resultFile.isFile()) {
                    resultFile = null;
                }
                if (resultFile == null && resourceRoots != null) {
                    for (File resourceRoot : resourceRoots) {
                        File potentialResource = new File(resourceRoot, name);
                        if (!potentialResource.isFile()) continue;
                        resultFile = potentialResource;
                        break;
                    }
                }
            }
            if (resultFile != null) {
                try {
                    result = new CacheEntry(resultFile, resultFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            } else {
                URL resource = super.getResource(name);
                result = resource != null ? new CacheEntry(null, resource) : null;
            }
            OverwriteWithMavenResourcesClassLoader overwriteWithMavenResourcesClassLoader2 = this;
            synchronized (overwriteWithMavenResourcesClassLoader2) {
                this._resourceCache.put(name, result);
            }
        }
        return result != null ? result.getUrl() : null;
    }

    @Override
    public Enumeration<URL> getResources(@Nonnull String name) throws IOException {
        Enumeration result;
        Collection<File> resourceRoots = this._resourceRoots;
        if (resourceRoots != null) {
            ArrayList<URL> foundStaticUrls = new ArrayList<URL>();
            for (File resourceRoot : resourceRoots) {
                File potentialResource = new File(resourceRoot, name);
                if (!potentialResource.isFile()) continue;
                foundStaticUrls.add(potentialResource.toURI().toURL());
            }
            Iterator combined = Iterators.concat(foundStaticUrls.iterator(), (Iterator)Iterators.forEnumeration(super.getResources(name)));
            result = Iterators.asEnumeration((Iterator)combined);
        } else {
            result = super.getResources(name);
        }
        return result;
    }

    @Nonnull
    protected List<MavenProjectWithModules> toProjectsRecursively(@Nonnull Collection<File> rootPoms) throws Exception {
        ArrayList<MavenProjectWithModules> projects = new ArrayList<MavenProjectWithModules>();
        MavenEnvironment environment = new MavenEnvironmentFactory().create();
        MavenProjectWithModulesFactory factory = new MavenProjectWithModulesFactory();
        for (File rootPom : rootPoms) {
            try {
                MavenProjectWithModules project = factory.createFor(environment, rootPom);
                this.enrichWithAllModulesRecursively(projects, project);
            }
            catch (ProjectBuildingException e) {
                LOG.warn("Could not build the project list for " + rootPom + ". Will ignore it now but this means that we could not erich the paths with it.", (Throwable)e);
            }
        }
        return projects;
    }

    protected void enrichWithAllModulesRecursively(@Nonnull Collection<MavenProjectWithModules> what, @Nonnull MavenProjectWithModules withProject) throws Exception {
        if (!what.contains(withProject)) {
            what.add(withProject);
            Collection<MavenProjectWithModules> modules = withProject.getModules();
            if (modules != null) {
                for (MavenProjectWithModules module : modules) {
                    this.enrichWithAllModulesRecursively(what, module);
                }
            }
        }
    }

    @Nonnull
    protected List<File> toResourceRoots(@Nonnull List<MavenProjectWithModules> projects) throws Exception {
        ArrayList<File> resourceRoots = new ArrayList<File>();
        for (MavenProjectWithModules project : projects) {
            MavenProject mavenProject = project.getProject();
            this.enrichWithResources(resourceRoots, mavenProject);
        }
        return resourceRoots;
    }

    protected void enrichWithResources(@Nonnull Collection<File> what, @Nonnull MavenProject of) throws Exception {
        List resources = of.getResources();
        if (resources != null) {
            for (Resource resource : resources) {
                File directory;
                String plainDirectory = resource.getDirectory();
                if (plainDirectory == null || !(directory = new File(plainDirectory).getCanonicalFile()).isDirectory() || what.contains(directory)) continue;
                what.add(directory);
            }
        }
    }

    public boolean isSetAsContextLoader() {
        return this._setAsContextLoader;
    }

    public void setSetAsContextLoader(boolean setAsContextLoader) {
        this._setAsContextLoader = setAsContextLoader;
    }

    public boolean isUseJvmWideCaching() {
        return this._useJvmWideCaching;
    }

    public void setUseJvmWideCaching(boolean useJvmWideCaching) {
        this._useJvmWideCaching = useJvmWideCaching;
    }

    public Collection<File> getRootPoms() {
        return this._rootPoms;
    }

    public void setRootPoms(Collection<File> rootPoms) {
        this._rootPoms = rootPoms;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean isDynamic() {
        return this._resourceRoots != null && !this._resourceRoots.isEmpty();
    }

    protected static class CacheEntry {
        private final File _file;
        private final URL _url;

        public CacheEntry(@Nullable File file, @Nonnull URL url) {
            this._file = file;
            this._url = url;
        }

        public File getFile() {
            return this._file;
        }

        public URL getUrl() {
            return this._url;
        }
    }
}

