/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.CountryCodeToRegionCodeMap;
import com.google.i18n.phonenumbers.MetadataLoader;
import com.google.i18n.phonenumbers.MetadataManager;
import com.google.i18n.phonenumbers.MetadataSource;
import com.google.i18n.phonenumbers.nano.Phonemetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MultiFileMetadataSourceImpl
implements MetadataSource {
    private static final Logger logger = Logger.getLogger(MultiFileMetadataSourceImpl.class.getName());
    private static final String META_DATA_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private final Map<String, Phonemetadata.PhoneMetadata> regionToMetadataMap = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Phonemetadata.PhoneMetadata> countryCodeToNonGeographicalMetadataMap = Collections.synchronizedMap(new HashMap());
    private final String filePrefix;
    private final MetadataLoader metadataLoader;

    public MultiFileMetadataSourceImpl(String filePrefix, MetadataLoader metadataLoader) {
        this.filePrefix = filePrefix;
        this.metadataLoader = metadataLoader;
    }

    public MultiFileMetadataSourceImpl(MetadataLoader metadataLoader) {
        this(META_DATA_FILE_PREFIX, metadataLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        Map<String, Phonemetadata.PhoneMetadata> map = this.regionToMetadataMap;
        synchronized (map) {
            if (!this.regionToMetadataMap.containsKey(regionCode)) {
                this.loadMetadataFromFile(regionCode, 0);
            }
        }
        return this.regionToMetadataMap.get(regionCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        Map<Integer, Phonemetadata.PhoneMetadata> map = this.countryCodeToNonGeographicalMetadataMap;
        synchronized (map) {
            List<String> regionCodes;
            if (!this.countryCodeToNonGeographicalMetadataMap.containsKey(countryCallingCode) && (regionCodes = CountryCodeToRegionCodeMap.getCountryCodeToRegionCodeMap().get(countryCallingCode)).size() == 1 && "001".equals(regionCodes.get(0))) {
                this.loadMetadataFromFile("001", countryCallingCode);
            }
        }
        return this.countryCodeToNonGeographicalMetadataMap.get(countryCallingCode);
    }

    void loadMetadataFromFile(String regionCode, int countryCallingCode) {
        boolean isNonGeoRegion = "001".equals(regionCode);
        String string = String.valueOf(String.valueOf(this.filePrefix));
        String string2 = String.valueOf(String.valueOf(isNonGeoRegion ? String.valueOf(countryCallingCode) : regionCode));
        String fileName = new StringBuilder(1 + string.length() + string2.length()).append(string).append("_").append(string2).toString();
        InputStream source = this.metadataLoader.loadMetadata(fileName);
        if (source == null) {
            String string3 = String.valueOf(fileName);
            logger.log(Level.SEVERE, string3.length() != 0 ? "missing metadata: ".concat(string3) : new String("missing metadata: "));
            String string4 = String.valueOf(fileName);
            throw new IllegalStateException(string4.length() != 0 ? "missing metadata: ".concat(string4) : new String("missing metadata: "));
        }
        try {
            Phonemetadata.PhoneMetadataCollection metadataCollection = MultiFileMetadataSourceImpl.loadMetadataAndCloseInput(new ObjectInputStream(source));
            Phonemetadata.PhoneMetadata[] metadataList = metadataCollection.metadata;
            if (metadataList.length == 0) {
                String string5 = String.valueOf(fileName);
                logger.log(Level.SEVERE, string5.length() != 0 ? "empty metadata: ".concat(string5) : new String("empty metadata: "));
                String string6 = String.valueOf(fileName);
                throw new IllegalStateException(string6.length() != 0 ? "empty metadata: ".concat(string6) : new String("empty metadata: "));
            }
            if (metadataList.length > 1) {
                String string7 = String.valueOf(fileName);
                logger.log(Level.WARNING, string7.length() != 0 ? "invalid metadata (too many entries): ".concat(string7) : new String("invalid metadata (too many entries): "));
            }
            Phonemetadata.PhoneMetadata metadata = metadataList[0];
            if (isNonGeoRegion) {
                this.countryCodeToNonGeographicalMetadataMap.put(countryCallingCode, metadata);
            } else {
                this.regionToMetadataMap.put(regionCode, metadata);
            }
        }
        catch (IOException e) {
            String string8 = String.valueOf(fileName);
            logger.log(Level.SEVERE, string8.length() != 0 ? "cannot load/parse metadata: ".concat(string8) : new String("cannot load/parse metadata: "), e);
            String string9 = String.valueOf(fileName);
            throw new RuntimeException(string9.length() != 0 ? "cannot load/parse metadata: ".concat(string9) : new String("cannot load/parse metadata: "), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Phonemetadata.PhoneMetadataCollection loadMetadataAndCloseInput(ObjectInputStream source) {
        int MULTI_FILE_BUFFER_SIZE = 16384;
        Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
        try {
            metadataCollection.mergeFrom(MetadataManager.convertStreamToByteBuffer(source, 16384));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error reading input (ignored)", e);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing input stream (ignored)", e);
            }
        }
        return metadataCollection;
    }
}

