/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.ssh.SshRemote;
import org.echocat.jomon.process.Process;
import org.echocat.jomon.runtime.io.ChunkAwareSerializer;
import org.echocat.jomon.runtime.io.SerializableBy;
import org.echocat.jomon.runtime.io.Serializers;
import org.echocat.jomon.runtime.io.StreamUtils;

public interface SshProcess
extends Process<String, Id> {

    @SerializableBy(value=SerializerImpl.class)
    public static interface Id {
        @Nullable
        public Long getPid();

        @Nonnull
        public SshRemote getRemote();

        public static class SerializerImpl
        implements ChunkAwareSerializer<Id> {
            public static final byte REGULAR_TYPE = -127;
            public static final byte NULL_TYPE = -128;
            public static final int CHUNK_SIZE = 9 + Serializers.getChunkSizeOf(SshRemote.class);

            public int getChunkSize() {
                return CHUNK_SIZE;
            }

            public void write(@Nullable Id value, @Nonnull DataOutput to) throws IOException {
                if (value != null) {
                    StreamUtils.writeByte((byte)-127, (DataOutput)to);
                    Long pid = value.getPid();
                    StreamUtils.writeLong((long)(pid != null ? pid : 0L), (DataOutput)to);
                    StreamUtils.writeObject(SshRemote.class, (Object)value.getRemote(), (DataOutput)to);
                } else {
                    StreamUtils.writeByte((byte)-128, (DataOutput)to);
                    StreamUtils.writeZeros((int)(CHUNK_SIZE - 1), (DataOutput)to);
                }
            }

            @Nullable
            public Id read(@Nonnull DataInput from) throws IOException {
                Impl result;
                short type = StreamUtils.readByte((DataInput)from);
                if (type == -128) {
                    StreamUtils.readZeros((DataInput)from, (int)(CHUNK_SIZE - 1));
                    result = null;
                } else if (type == -127) {
                    long pid = StreamUtils.readLong((DataInput)from);
                    SshRemote remote = (SshRemote)StreamUtils.readObject(SshRemote.class, (DataInput)from);
                    result = new Impl(pid != 0L ? Long.valueOf(pid) : null, remote);
                } else {
                    throw new IOException("Found no valid type marker.");
                }
                return result;
            }
        }

        public static class Impl
        implements Id {
            @Nullable
            private final Long _pid;
            @Nonnull
            private final SshRemote _remote;

            @Nonnull
            public static Id id(@Nullable Long pid, @Nonnull SshRemote session) {
                return new Impl(pid, session);
            }

            public Impl(@Nullable Long pid, @Nonnull SshRemote remote) {
                this._pid = pid;
                this._remote = remote;
            }

            @Override
            @Nullable
            public Long getPid() {
                return this._pid;
            }

            @Override
            @Nonnull
            public SshRemote getRemote() {
                return this._remote;
            }

            public boolean equals(Object o) {
                boolean result;
                if (this == o) {
                    result = true;
                } else if (!(o instanceof Id)) {
                    result = false;
                } else {
                    Id that = (Id)o;
                    Long pid = this.getPid();
                    result = (pid != null ? pid.equals(that.getPid()) : that.getPid() == null) && this.getRemote().equals(that.getRemote());
                }
                return result;
            }

            public int hashCode() {
                Long pid = this.getPid();
                int result = pid != null ? pid.hashCode() : 0;
                result = 31 * result + this.getRemote().hashCode();
                return result;
            }

            public String toString() {
                Long pid = this.getPid();
                return (pid != null ? pid + "@" : "") + this.getRemote();
            }
        }
    }
}

