/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;

public class SshProcessUtils {
    @Nonnull
    public static List<String> getCompleteCommandLine(@Nonnull String executable, @Nullable List<String> arguments) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(executable);
        CollectionUtils.addAll(command, arguments);
        return CollectionUtils.asImmutableList(command);
    }

    @Nonnull
    public static String getCompleteCommandLineArguments(@Nullable Iterable<String> commandLine) {
        StringBuilder sb = new StringBuilder();
        for (String arg : commandLine) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (arg.isEmpty()) {
                sb.append("\"\"");
            }
            if (arg.contains(" ") || arg.contains("\\") || arg.contains("\"")) {
                sb.append('\"').append(arg.replace("\\", "\\\\").replace("\"", "\\\"")).append('\"');
                continue;
            }
            sb.append(arg);
        }
        return sb.toString();
    }

    @Nonnull
    public static String getCompleteCommandLineArguments(@Nonnull String executable, @Nullable List<String> arguments) {
        return SshProcessUtils.getCompleteCommandLineArguments(SshProcessUtils.getCompleteCommandLine(executable, arguments));
    }

    private SshProcessUtils() {
    }
}

