/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.net.ssh.SshContext;
import org.echocat.jomon.runtime.io.ByteUtils;
import org.echocat.jomon.runtime.io.ChunkAwareSerializer;
import org.echocat.jomon.runtime.io.SerializableBy;
import org.echocat.jomon.runtime.io.StreamUtils;

@SerializableBy(value=SerializerImpl.class)
public interface SshRemote
extends SshContext {
    public static final int DEFAULT_PORT = 22;

    @Nonnull
    public InetSocketAddress getAddress();

    @Nonnull
    public String getUser();

    @Nullable
    public String getPassword();

    public static class SerializerImpl
    implements ChunkAwareSerializer<SshRemote> {
        public static final byte REGULAR_TYPE = -127;
        public static final byte NULL_TYPE = -128;
        public static final int STRING_BUFFER_SIZE = 255;
        public static final Charset CHARSET = ByteUtils.DEFAULT_CHARSET;
        public static final int CHUNK_SIZE = 1 + ByteUtils.DEFAULT_STRING_CHUNK_SIZE + 4 + ByteUtils.DEFAULT_STRING_CHUNK_SIZE + ByteUtils.DEFAULT_STRING_CHUNK_SIZE;

        public int getChunkSize() {
            return CHUNK_SIZE;
        }

        public void write(@Nullable SshRemote value, @Nonnull DataOutput to) throws IOException {
            if (value != null) {
                StreamUtils.writeByte((byte)-127, (DataOutput)to);
                InetSocketAddress address = value.getAddress();
                StreamUtils.writeString((int)255, (String)address.getHostString(), (Charset)CHARSET, (DataOutput)to);
                StreamUtils.writeInteger((int)address.getPort(), (DataOutput)to);
                StreamUtils.writeString((int)255, (String)value.getUser(), (Charset)CHARSET, (DataOutput)to);
                StreamUtils.writeString((int)255, (String)value.getPassword(), (Charset)CHARSET, (DataOutput)to);
            } else {
                StreamUtils.writeByte((byte)-128, (DataOutput)to);
                StreamUtils.writeZeros((int)(CHUNK_SIZE - 1), (DataOutput)to);
            }
        }

        @Nullable
        public SshRemote read(@Nonnull DataInput from) throws IOException {
            Impl result;
            short type = StreamUtils.readByte((DataInput)from);
            if (type == -128) {
                StreamUtils.readZeros((DataInput)from, (int)(CHUNK_SIZE - 1));
                result = null;
            } else if (type == -127) {
                String hostString = StreamUtils.readString((DataInput)from, (int)255, (Charset)CHARSET);
                int port = StreamUtils.readInteger((DataInput)from);
                String user = StreamUtils.readString((DataInput)from, (int)255, (Charset)CHARSET);
                String password = StreamUtils.readString((DataInput)from, (int)255, (Charset)CHARSET);
                result = new Impl(InetSocketAddress.createUnresolved(hostString, port), user, password);
            } else {
                throw new IOException("Found no valid type marker.");
            }
            return result;
        }
    }

    public static class Impl
    implements SshRemote {
        @Nonnull
        private final InetSocketAddress _address;
        @Nullable
        private final String _user;
        @Nullable
        private final String _password;

        @Nonnull
        public static Impl remote(@Nonnull InetSocketAddress address, @Nullable String user, @Nullable String password) {
            return new Impl(address, user, password);
        }

        @Nonnull
        public static Impl remote(@Nonnull InetSocketAddress address, @Nullable String user) {
            return Impl.remote(address, user, null);
        }

        @Nonnull
        public static Impl remote(@Nonnull InetSocketAddress address) {
            return Impl.remote(address, null);
        }

        @Nonnull
        public static Impl remote(@Nonnull String remoteAsString) {
            int port;
            int lastAt = remoteAsString.lastIndexOf(64);
            boolean hasUserPart = lastAt >= 0 && lastAt + 1 < remoteAsString.length();
            String user = hasUserPart ? remoteAsString.substring(0, lastAt) : null;
            String hostAndPort = hasUserPart ? remoteAsString.substring(lastAt + 1) : remoteAsString;
            int lastDoubleDot = hostAndPort.lastIndexOf(58);
            boolean hasPortPart = lastDoubleDot >= 0 && lastDoubleDot + 1 < hostAndPort.length();
            String host = hasPortPart ? hostAndPort.substring(0, lastDoubleDot) : hostAndPort;
            try {
                port = hasPortPart ? Integer.parseInt(hostAndPort.substring(lastDoubleDot + 1)) : 22;
            }
            catch (NumberFormatException ignored) {
                host = hostAndPort;
                port = 22;
            }
            if (port <= 0) {
                throw new IllegalArgumentException("Illegal remote provided - containing illegal port: " + remoteAsString);
            }
            try {
                return Impl.remote(new InetSocketAddress(InetAddress.getByName(host), port), user);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Illegal remote provided - illegal host: " + remoteAsString, e);
            }
        }

        public Impl(@Nonnull InetSocketAddress address, @Nullable String user, @Nullable String password) {
            this._address = address;
            this._user = user;
            this._password = password;
        }

        @Override
        @Nonnull
        public InetSocketAddress getAddress() {
            return this._address;
        }

        @Override
        @Nonnull
        public String getUser() {
            String user = this.getGivenUser();
            if (StringUtils.isEmpty((CharSequence)user) && StringUtils.isEmpty((CharSequence)(user = System.getProperty("user.name")))) {
                throw new RuntimeException("Could not determinate the current username.");
            }
            return user;
        }

        @Nullable
        protected String getGivenUser() {
            return this._user;
        }

        @Override
        @Nullable
        public String getPassword() {
            return this._password;
        }

        public String toString() {
            InetSocketAddress address = this.getAddress();
            String user = this.getGivenUser();
            StringBuilder sb = new StringBuilder();
            if (!StringUtils.isEmpty((CharSequence)user)) {
                sb.append(user).append('@');
            }
            sb.append(address.getHostName());
            int port = address.getPort();
            if (port != 22) {
                sb.append(':').append(port);
            }
            return sb.toString();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

