/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh.jsch;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.echocat.jomon.net.ssh.SshContext;
import org.echocat.jomon.net.ssh.SshException;
import org.echocat.jomon.net.ssh.SshGeneratedProcess;
import org.echocat.jomon.net.ssh.SshGeneratedProcessRequirement;
import org.echocat.jomon.net.ssh.SshProcess;
import org.echocat.jomon.net.ssh.SshProcessRepository;
import org.echocat.jomon.net.ssh.SshRemote;
import org.echocat.jomon.net.ssh.SshSession;
import org.echocat.jomon.net.ssh.SshSessionRequirement;
import org.echocat.jomon.net.ssh.jsch.JschSshGeneratedProcess;
import org.echocat.jomon.net.ssh.jsch.JschSshSession;
import org.echocat.jomon.net.ssh.jsch.JschSshSessionGenerator;
import org.echocat.jomon.net.ssh.jsch.JschUtils;
import org.echocat.jomon.process.CouldNotStartException;
import org.echocat.jomon.process.Pty;
import org.echocat.jomon.runtime.util.ResourceUtils;

public class JschSshProcessRepository
implements SshProcessRepository {
    @Nonnull
    private final JschSshSessionGenerator _sessionGenerator;

    public JschSshProcessRepository(@Nonnull JschSshSessionGenerator sessionGenerator) {
        this._sessionGenerator = sessionGenerator;
    }

    /*
     * Loose catch block
     */
    @Nonnull
    public SshGeneratedProcess generate(@Nonnull SshGeneratedProcessRequirement requirement) {
        boolean success = false;
        SshSession sshSession = this.getSessionOf(requirement);
        boolean closeSession = requirement.getContext() != sshSession;
        try {
            Session session = this.getJschSessionOf(sshSession);
            ChannelExec exec = JschUtils.open(session, ChannelExec.class);
            try {
                JschSshGeneratedProcess result = this.createAndConfigureProcess(requirement, exec, sshSession, closeSession);
                success = true;
                JschSshGeneratedProcess jschSshGeneratedProcess = result;
                return jschSshGeneratedProcess;
            }
            catch (Exception e) {
                throw new CouldNotStartException("Could not start or configure process.", (Throwable)e);
            }
            finally {
                if (!success) {
                    try {
                        exec.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!success && closeSession) {
                ResourceUtils.closeQuietly((AutoCloseable)sshSession);
            }
        }
    }

    @Nonnull
    protected JschSshGeneratedProcess createAndConfigureProcess(@Nonnull SshGeneratedProcessRequirement requirement, @Nonnull ChannelExec exec, @Nonnull SshSession session, boolean closeContext) throws IOException {
        exec.setCommand(requirement.getCompleteCommandLineAsString());
        Pty pty = requirement.getPty();
        exec.setPty(pty != null);
        if (pty != null) {
            exec.setPtyType(pty.getType(), pty.getCharacterWidth(), pty.getCharacterHeight(), pty.getPixelWidth(), pty.getPixelWidth());
        }
        for (Map.Entry entry : requirement.getEnvironment().entrySet()) {
            exec.setEnv((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            exec.connect();
        }
        catch (JSchException e) {
            throw new SshException(e.getMessage(), e);
        }
        return new JschSshGeneratedProcess(requirement, exec, SshProcess.Id.Impl.id(null, session.getRemote()), closeContext);
    }

    @Nonnull
    protected SshSession getSessionOf(@Nonnull SshGeneratedProcessRequirement requirement) {
        SshSession result;
        SshContext context = requirement.getContext();
        if (context instanceof SshSession) {
            result = (SshSession)context;
        } else if (context instanceof SshRemote) {
            result = this._sessionGenerator.generate(SshSessionRequirement.session((SshRemote)context));
        } else {
            throw new UnsupportedOperationException("This implementation of " + SshProcessRepository.class.getName() + " does not support a " + SshContext.class.getName() + " of type " + context.getClass().getName() + ".");
        }
        return result;
    }

    @Nonnull
    protected Session getJschSessionOf(@Nonnull SshSession sshSession) {
        if (!(sshSession instanceof JschSshSession)) {
            throw new IllegalArgumentException("Could not handle sessions of type " + sshSession.getClass().getName() + ".");
        }
        return ((JschSshSession)sshSession).getSession();
    }

    @Nonnull
    protected JschSshSessionGenerator getSessionGenerator() {
        return this._sessionGenerator;
    }
}

