/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh.jsch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.NotifyingIO;
import com.jcraft.jsch.Session;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.echocat.jomon.net.ssh.SshConnectionException;
import org.echocat.jomon.net.ssh.SshSystemException;
import org.echocat.jomon.runtime.reflection.ClassUtils;

public class JschUtils {
    @Nonnull
    private static final Map<Class<? extends Channel>, String> TYPE_TO_NAME = JschUtils.createTypeToName();
    @Nonnull
    private static final Field IO_FIELD = ClassUtils.getFieldOf(Channel.class, IO.class, (String)"io", (boolean)false);

    private static Map<Class<? extends Channel>, String> createTypeToName() {
        HashMap<Class<? extends Channel>, String> typeToName = new HashMap<Class<? extends Channel>, String>();
        JschUtils.addIfPresent(typeToName, "com.jcraft.jsch.ChannelSession", "session");
        JschUtils.addIfPresent(typeToName, "com.jcraft.jsch.ChannelShell", "shell");
        JschUtils.addIfPresent(typeToName, "com.jcraft.jsch.ChannelExec", "exec");
        JschUtils.addIfPresent(typeToName, "com.jcraft.jsch.ChannelX11", "x11");
        JschUtils.addIfPresent(typeToName, "com.jcraft.jsch.ChannelAgentForwarding", "auth-agent@openssh.com");
        JschUtils.addIfPresent(typeToName, "com.jcraft.jsch.ChannelDirectTCPIP", "direct-tcpip");
        JschUtils.addIfPresent(typeToName, "com.jcraft.jsch.ChannelForwardedTCPIP", "forwarded-tcpip");
        JschUtils.addIfPresent(typeToName, "com.jcraft.jsch.ChannelSftp", "sftp");
        JschUtils.addIfPresent(typeToName, "com.jcraft.jsch.ChannelSubsystem", "subsystem");
        return Collections.unmodifiableMap(typeToName);
    }

    private static void addIfPresent(@Nonnull Map<Class<? extends Channel>, String> typeToName, @Nonnull String className, @Nonnull String typeName) {
        try {
            typeToName.put(Class.forName(className), typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Nonnull
    public static <T extends Channel> T open(@Nonnull Session session, @Nonnull Class<T> type) {
        String name = TYPE_TO_NAME.get(type);
        if (name == null) {
            throw new IllegalArgumentException("Type " + type.getName() + " is unknown.");
        }
        return JschUtils.open(session, type, name);
    }

    @Nonnull
    public static <T extends Channel> T open(@Nonnull Session session, @Nonnull Class<T> type, @Nonnull String typeName) {
        Channel channel;
        if (!session.isConnected()) {
            throw new SshConnectionException("Not connected.");
        }
        try {
            channel = session.openChannel(typeName);
        }
        catch (JSchException e) {
            throw new SshSystemException("Could not open channel '" + typeName + "'.", e);
        }
        if (!type.isInstance(channel)) {
            throw new SshSystemException("Created channel " + channel + "  is not of type " + type.getName() + ".");
        }
        return (T)((Channel)type.cast(channel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(@Nonnull NotifyingIO.EventConsumer consumer, @Nonnull Channel on) {
        Channel channel = on;
        synchronized (channel) {
            try {
                NotifyingIO notifyingIO;
                IO io = (IO)IO_FIELD.get(on);
                if (io instanceof NotifyingIO) {
                    notifyingIO = (NotifyingIO)io;
                } else {
                    notifyingIO = new NotifyingIO(io);
                    IO_FIELD.set(on, (Object)notifyingIO);
                }
                notifyingIO.setEventConsumer(consumer);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set the io field of '" + on + "'.", e);
            }
        }
    }

    private JschUtils() {
    }
}

