/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.spring.ApplicationContextUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AutomaticServicesDiscovery<V, C extends Collection<V>>
implements FactoryBean<C>,
ApplicationContextAware {
    private final Class<V> _expectedType;
    private ApplicationContext _applicationContext;
    private Collection<Class<?>> _excludes;

    protected AutomaticServicesDiscovery(@Nonnull Class<V> expectedType) {
        this._expectedType = expectedType;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this._applicationContext = applicationContext;
    }

    protected boolean isApplicable(@Nonnull Class<?> type, @Nonnull String withBeanName, @Nonnull ApplicationContext of) {
        return this._expectedType.isAssignableFrom(type);
    }

    protected boolean isApplicable(@Nonnull V bean, @Nonnull String withBeanName, @Nonnull ApplicationContext of) {
        return true;
    }

    protected abstract C createNewCollection();

    public C getObject() throws Exception {
        String[] names;
        C values = this.createNewCollection();
        for (String name : names = this._applicationContext.getBeanDefinitionNames()) {
            Object bean;
            Class<?> type = this.findTypeOfBeanDefinition(name);
            if (type == null || !this.isApplicable((V)type, name, this._applicationContext) || this.isExcluded(type) || !this.isApplicable(bean = this._applicationContext.getBean(name, this._expectedType), name, this._applicationContext)) continue;
            values.add((Object)bean);
        }
        return values;
    }

    protected boolean isExcluded(@Nonnull Class<?> type) {
        boolean excluded = false;
        if (this._excludes != null) {
            for (Class<?> exclude : this._excludes) {
                if (!exclude.isAssignableFrom(type)) continue;
                excluded = true;
                break;
            }
        }
        return excluded;
    }

    @Nullable
    protected Class<?> findTypeOfBeanDefinition(@Nonnull String beanName) {
        return ApplicationContextUtils.findTypeOfBeanDefinition(this._applicationContext, beanName);
    }

    public Collection<Class<?>> getExcludes() {
        return this._excludes;
    }

    public void setExcludes(Collection<Class<?>> excludes) {
        this._excludes = excludes;
    }

    public Class<?> getObjectType() {
        return this.createNewCollection().getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

