/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.spring.AutomaticServicesDiscovery;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class BeanFactoryUtils {
    private BeanFactoryUtils() {
    }

    @Nullable
    public static Class<?> findTypeOfBeanDefinition(@Nonnull BeanFactory beanFactory, @Nonnull String beanName) {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("Currently there is only a beanFactory of type " + ConfigurableListableBeanFactory.class.getName() + " supported.");
        }
        return BeanFactoryUtils.findTypeOfBeanDefinition((ConfigurableListableBeanFactory)beanFactory, beanName);
    }

    @Nullable
    public static Class<?> findTypeOfBeanDefinition(@Nonnull ConfigurableListableBeanFactory beanFactory, @Nonnull String beanName) {
        Class<?> type;
        BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
        if (definition != null && definition.getFactoryMethodName() == null) {
            String beanClassName = definition.getBeanClassName();
            if (beanClassName != null) {
                try {
                    type = AutomaticServicesDiscovery.class.getClassLoader().loadClass(beanClassName);
                }
                catch (ClassNotFoundException ignored) {
                    type = null;
                }
            } else {
                type = null;
            }
        } else {
            type = null;
        }
        return type == null || FactoryBean.class.isAssignableFrom(type) ? null : type;
    }

    @Nullable
    public static String findScopeOfBeanDefinition(@Nonnull BeanFactory beanFactory, @Nonnull String beanName) throws NoSuchBeanDefinitionException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("Currently there is only a beanFactory of type " + ConfigurableListableBeanFactory.class.getName() + " supported.");
        }
        return BeanFactoryUtils.findScopeOfBeanDefinition((ConfigurableListableBeanFactory)beanFactory, beanName);
    }

    @Nullable
    public static String findScopeOfBeanDefinition(@Nonnull ConfigurableListableBeanFactory beanFactory, @Nonnull String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
        if (definition == null) {
            throw new NoSuchBeanDefinitionException("Could not find a bean named '" + beanName + "'.");
        }
        return definition.getScope();
    }
}

