/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.instance.InstanceProvider;
import org.echocat.jomon.runtime.logging.LogLevel;
import org.echocat.jomon.runtime.logging.Slf4jUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BeanProvider
implements InstanceProvider,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(BeanProvider.class);
    @Nonnull
    private final Map<Class<?>, Object> _localSingletonCache = new WeakHashMap();
    @Nullable
    private ApplicationContext _applicationContext;
    private boolean _createLocaleBeansIfNotPresentInApplicationContext = true;
    @Nonnull
    private LogLevel _logLevelForLocalCreationOfBeans = LogLevel.debug;
    @Nullable
    private Pattern _logLocalCreationOfBeansThatNamesMatch;

    public boolean isCreateLocaleBeansIfNotPresentInApplicationContext() {
        return this._createLocaleBeansIfNotPresentInApplicationContext;
    }

    public void setCreateLocaleBeansIfNotPresentInApplicationContext(boolean createLocaleBeansIfNotPresentInApplicationContext) {
        this._createLocaleBeansIfNotPresentInApplicationContext = createLocaleBeansIfNotPresentInApplicationContext;
    }

    @Nonnull
    public LogLevel getLogLevelForLocalCreationOfBeans() {
        return this._logLevelForLocalCreationOfBeans;
    }

    public void setLogLevelForLocalCreationOfBeans(@Nonnull LogLevel logLevelForLocalCreationOfBeans) {
        this._logLevelForLocalCreationOfBeans = logLevelForLocalCreationOfBeans;
    }

    @Nullable
    public Pattern getLogLocalCreationOfBeansThatNamesMatch() {
        return this._logLocalCreationOfBeansThatNamesMatch;
    }

    public void setLogLocalCreationOfBeansThatNamesMatch(@Nullable Pattern logLocalCreationOfBeansThatNamesMatch) {
        this._logLocalCreationOfBeansThatNamesMatch = logLocalCreationOfBeansThatNamesMatch;
    }

    @Nonnull
    public <T> T provideFor(@Nonnull String name, @Nonnull Class<T> clazz, @Nonnull InstanceProvider.Type type) {
        Object result;
        AutowireCapableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsBean(name)) {
            this.validateTypeAgainstBeanConfiguration(name, type);
            result = beanFactory.getBean(name, clazz);
        } else if (this.isCreateLocaleBeansIfNotPresentInApplicationContext()) {
            result = type == InstanceProvider.Type.singleton ? this.getLocalCreatedAndConfiguredSingleton(name, clazz) : this.createInstanceAndConfigure(name, clazz);
        } else {
            throw new IllegalArgumentException("No such bean named '" + name + "' found.");
        }
        return (T)result;
    }

    @Nonnull
    public <T> T provideFor(@Nonnull Class<T> clazz, @Nonnull InstanceProvider.Type type) {
        return this.provideFor(clazz.getName(), clazz, type);
    }

    @Nonnull
    public <T> T provideFor(@Nonnull String name, @Nonnull Class<T> clazz) {
        return this.provideFor(name, clazz, InstanceProvider.Type.undefined);
    }

    @Nonnull
    public <T> T provideFor(@Nonnull Class<T> clazz) {
        return this.provideFor(clazz, InstanceProvider.Type.undefined);
    }

    protected void validateTypeAgainstBeanConfiguration(@Nonnull String name, @Nonnull InstanceProvider.Type type) {
        if (type != InstanceProvider.Type.undefined) {
            BeanDefinition definition = this.getBeanDefinitionRegistry().getBeanDefinition(name);
            String scope = definition.getScope();
            if (type == InstanceProvider.Type.multiton && !"prototype".equals(scope)) {
                throw new IllegalArgumentException("The bean '" + name + "' was requested as " + type + ". This requires the scope '" + "prototype" + "' but was '" + scope + "'.");
            }
            if (type == InstanceProvider.Type.singleton && !"singleton".equals(scope)) {
                throw new IllegalArgumentException("The bean '" + name + "' was requested as " + type + ". This requires the scope '" + "singleton" + "' but was '" + scope + "'.");
            }
        }
    }

    @Nonnull
    protected <T> T createInstanceAndConfigure(@Nonnull String name, @Nonnull Class<T> type) {
        T result = this.createInstanceOf(type);
        this.getBeanFactory().autowireBean(result);
        if (Slf4jUtils.isEnabled((Logger)LOG, (LogLevel)this.getLogLevelForLocalCreationOfBeans()) && this.shouldLogLocalCreationOf(name)) {
            Slf4jUtils.log((Logger)LOG, (LogLevel)this.getLogLevelForLocalCreationOfBeans(), (String)("Created bean '" + name + "' of type " + type.getName() + " locally because not present in application context."));
        }
        return result;
    }

    protected boolean shouldLogLocalCreationOf(@Nonnull String name) {
        return this._logLocalCreationOfBeansThatNamesMatch == null || this._logLocalCreationOfBeansThatNamesMatch.matcher(name).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected <T> T getLocalCreatedAndConfiguredSingleton(@Nonnull String name, @Nonnull Class<T> clazz) {
        Map<Class<?>, Object> map = this._localSingletonCache;
        synchronized (map) {
            Object result = this._localSingletonCache.get(clazz);
            if (result == null) {
                result = this.createInstanceAndConfigure(name, clazz);
                this._localSingletonCache.put(clazz, result);
            }
            return (T)result;
        }
    }

    @Nonnull
    protected <T> T createInstanceOf(@Nonnull Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not create new instance of " + type.getName() + ".", e);
        }
        catch (InstantiationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Could not create new instance of " + type.getName() + ".", cause != null ? cause : e);
        }
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) throws BeansException {
        if (!(context.getAutowireCapableBeanFactory() instanceof BeanDefinitionRegistry)) {
            throw new IllegalArgumentException("The autowireCapableBeanFactory of given context must also implement " + BeanDefinitionRegistry.class.getName() + ".");
        }
        this._applicationContext = context;
    }

    @Nonnull
    protected ApplicationContext getApplicationContext() {
        ApplicationContext context = this._applicationContext;
        if (context == null) {
            throw new IllegalStateException("setApplicationContext() was not called yet.");
        }
        context.getAutowireCapableBeanFactory();
        return context;
    }

    @Nonnull
    protected AutowireCapableBeanFactory getBeanFactory() {
        return this.getApplicationContext().getAutowireCapableBeanFactory();
    }

    @Nonnull
    protected BeanDefinitionRegistry getBeanDefinitionRegistry() {
        return (BeanDefinitionRegistry)this.getBeanFactory();
    }
}

