/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import java.util.ArrayList;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.spring.application.ApplicationContextGenerator;
import org.echocat.jomon.spring.application.ApplicationContextRequirement;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationContextGenerators {
    @Nonnull
    private static final Iterable<ApplicationContextGenerator> ALL = ApplicationContextGenerators.loadAll();
    @Nonnull
    private static final ApplicationContextGenerator DEFAULT = new Combined();

    private ApplicationContextGenerators() {
    }

    @Nonnull
    public static ApplicationContextGenerator getDefault() {
        return DEFAULT;
    }

    @Nonnull
    public static ApplicationContextGenerator applicationContextGenerator() {
        return ApplicationContextGenerators.getDefault();
    }

    @Nonnull
    public static Iterable<ApplicationContextGenerator> getAll() {
        return ALL;
    }

    @Nonnull
    private static Iterable<ApplicationContextGenerator> loadAll() {
        ArrayList result = new ArrayList();
        CollectionUtils.addAll(result, ServiceLoader.load(ApplicationContextGenerator.class));
        return CollectionUtils.asImmutableList(result);
    }

    private static class Combined
    implements ApplicationContextGenerator {
        private Combined() {
        }

        @Nonnull
        public ConfigurableApplicationContext generate(@Nonnull ApplicationContextRequirement requirement) {
            ConfigurableApplicationContext result = null;
            for (ApplicationContextGenerator generator : ALL) {
                if (!generator.supports(requirement)) continue;
                result = (ConfigurableApplicationContext)generator.generate(requirement);
            }
            if (result == null) {
                throw new IllegalArgumentException("Could not generate context for " + requirement + ".");
            }
            return result;
        }

        @Override
        public boolean supports(@Nonnull ApplicationContextRequirement configuration) {
            boolean result = false;
            for (ApplicationContextGenerator generator : ALL) {
                if (!generator.supports(configuration)) continue;
                result = true;
                break;
            }
            return result;
        }
    }
}

