/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.generation.Requirement;
import org.springframework.context.ApplicationContext;

public interface ApplicationContextRequirement
extends Requirement {
    @Nullable
    public ApplicationContext getParentApplicationContext();

    @Nonnull
    public ClassLoader getClassLoader();

    public static abstract class Support<T extends Support<T>>
    implements ApplicationContextRequirement {
        @Nonnull
        private ClassLoader _classLoader = Thread.currentThread().getContextClassLoader();
        @Nullable
        private ApplicationContext _parentApplicationContext;

        public void setClassLoader(@Nonnull ClassLoader classLoader) {
            this._classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        }

        @Nonnull
        public T withClassLoader(@Nonnull ClassLoader classLoader) {
            this.setClassLoader(classLoader);
            return this.thisObject();
        }

        @Override
        @Nonnull
        public ClassLoader getClassLoader() {
            return this._classLoader;
        }

        @Override
        @Nullable
        public ApplicationContext getParentApplicationContext() {
            return this._parentApplicationContext;
        }

        public void setParentApplicationContext(@Nullable ApplicationContext parentApplicationContext) {
            this._parentApplicationContext = parentApplicationContext;
        }

        @Nonnull
        public T withParentApplicationContext(@Nullable ApplicationContext parent) {
            this._parentApplicationContext = parent;
            return this.thisObject();
        }

        @Nonnull
        protected T thisObject() {
            return (T)this;
        }
    }
}

