/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import java.util.ArrayList;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.spring.application.Application;
import org.echocat.jomon.spring.application.ApplicationInformation;
import org.echocat.jomon.spring.application.ApplicationInformationGenerator;
import org.echocat.jomon.spring.application.ApplicationInformationRequirement;

public class ApplicationInformationGenerators {
    @Nonnull
    private static final Iterable<ApplicationInformationGenerator> ALL = ApplicationInformationGenerators.loadAll();
    @Nonnull
    private static final ApplicationInformationGenerator DEFAULT = new Combined();

    private ApplicationInformationGenerators() {
    }

    @Nonnull
    public static ApplicationInformationGenerator getDefault() {
        return DEFAULT;
    }

    @Nonnull
    public static ApplicationInformationGenerator applicationInformationGenerator() {
        return ApplicationInformationGenerators.getDefault();
    }

    @Nonnull
    public static Iterable<ApplicationInformationGenerator> getAll() {
        return ALL;
    }

    @Nonnull
    private static Iterable<ApplicationInformationGenerator> loadAll() {
        ArrayList result = new ArrayList();
        CollectionUtils.addAll(result, ServiceLoader.load(ApplicationInformationGenerator.class));
        return CollectionUtils.asImmutableList(result);
    }

    public static class FallbackInformation
    implements ApplicationInformation {
        @Override
        @Nullable
        public String getBanner() {
            return null;
        }

        @Override
        @Nonnull
        public String getTitle() {
            return Application.class.getName();
        }

        @Override
        @Nullable
        public String getName() {
            return null;
        }

        @Override
        @Nullable
        public String getVersion() {
            return null;
        }

        @Override
        @Nullable
        public String getBuildRevision() {
            return null;
        }

        @Override
        @Nullable
        public String getBuildDate() {
            return null;
        }
    }

    private static class Combined
    implements ApplicationInformationGenerator {
        private Combined() {
        }

        @Nonnull
        public ApplicationInformation generate(@Nonnull ApplicationInformationRequirement requirement) {
            ApplicationInformation result = null;
            for (ApplicationInformationGenerator generator : ALL) {
                if (!generator.supports(requirement)) continue;
                result = (ApplicationInformation)generator.generate(requirement);
            }
            if (result == null) {
                result = new FallbackInformation();
            }
            return result;
        }

        @Override
        public boolean supports(@Nonnull ApplicationInformationRequirement requirement) {
            return true;
        }
    }
}

