/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.runtime.concurrent.StopWatch;
import org.echocat.jomon.runtime.generation.Requirement;
import org.echocat.jomon.runtime.logging.LoggingEnvironment;
import org.echocat.jomon.runtime.logging.LoggingEnvironmentGenerator;
import org.echocat.jomon.runtime.logging.LoggingEnvironmentGenerators;
import org.echocat.jomon.spring.ContextLoadThreadGroup;
import org.echocat.jomon.spring.application.Application;
import org.echocat.jomon.spring.application.ApplicationContextGenerator;
import org.echocat.jomon.spring.application.ApplicationContextGenerators;
import org.echocat.jomon.spring.application.ApplicationGenerator;
import org.echocat.jomon.spring.application.ApplicationInformation;
import org.echocat.jomon.spring.application.ApplicationInformationGenerator;
import org.echocat.jomon.spring.application.ApplicationInformationGenerators;
import org.echocat.jomon.spring.application.ApplicationInformationRequirement;
import org.echocat.jomon.spring.application.ApplicationRequirement;
import org.echocat.jomon.spring.application.ApplicationSuccessfulInitiatedReceiver;
import org.echocat.jomon.spring.application.DefaultApplication;
import org.slf4j.Logger;
import org.springframework.context.ConfigurableApplicationContext;

@ThreadSafe
public class DefaultApplicationGenerator
implements ApplicationGenerator {
    @Nonnull
    private final ApplicationContextGenerator _applicationContextGenerator;
    @Nonnull
    private final ApplicationInformationGenerator _applicationInformationGenerator;
    @Nonnull
    private final LoggingEnvironmentGenerator _loggingEnvironmentGenerator;

    public DefaultApplicationGenerator() {
        this(ApplicationContextGenerators.applicationContextGenerator(), ApplicationInformationGenerators.applicationInformationGenerator(), LoggingEnvironmentGenerators.loggingEnvironmentGenerator());
    }

    public DefaultApplicationGenerator(@Nonnull ApplicationContextGenerator applicationContextGenerator, @Nonnull ApplicationInformationGenerator applicationInformationGenerator, @Nonnull LoggingEnvironmentGenerator loggingEnvironmentGenerator) {
        this._applicationContextGenerator = applicationContextGenerator;
        this._applicationInformationGenerator = applicationInformationGenerator;
        this._loggingEnvironmentGenerator = loggingEnvironmentGenerator;
    }

    @Override
    public boolean supports(@Nonnull ApplicationRequirement requirement) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Application generate(@Nonnull ApplicationRequirement requirement) {
        ApplicationInformation information = this.generateApplicationInformationFor(requirement);
        LoggingEnvironment loggingEnvironment = this.generateLoggingEnvironmentFor(requirement);
        StopWatch stopWatch = new StopWatch();
        this.displayBannerIfNeeded(information);
        Logger logger = loggingEnvironment.getLogger(DefaultApplicationGenerator.class);
        logger.info("Starting " + information.getTitle() + "...");
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)this.getApplicationContextGenerator().generate(requirement.getApplicationContextRequirement());
        boolean success = false;
        boolean applicationContextStarted = false;
        try {
            DefaultApplication application = new DefaultApplication(applicationContext, information, loggingEnvironment);
            application.init();
            applicationContextStarted = true;
            this.waitForContextLoadThreads(applicationContext);
            logger.info("Starting " + information.getTitle() + "... DONE! (after: " + stopWatch.toCurrentPattern(TimeUnit.MILLISECONDS) + ")");
            this.notifyApplicationSuccessfulInitiated(application);
            success = true;
            DefaultApplication defaultApplication = application;
            return defaultApplication;
        }
        finally {
            if (applicationContextStarted && !success) {
                applicationContext.close();
            }
        }
    }

    protected void displayBannerIfNeeded(@Nonnull ApplicationInformation information) {
        String banner = information.getBanner();
        if (!StringUtils.isEmpty((CharSequence)banner)) {
            System.out.println(banner);
        }
    }

    protected void notifyApplicationSuccessfulInitiated(@Nonnull Application application) {
        for (ApplicationSuccessfulInitiatedReceiver receiver : application.getApplicationContext().getBeansOfType(ApplicationSuccessfulInitiatedReceiver.class).values()) {
            receiver.onApplicationSuccessfulInitiated(application);
        }
    }

    protected void waitForContextLoadThreads(@Nonnull ConfigurableApplicationContext applicationContext) {
        try {
            for (ContextLoadThreadGroup contextLoadThreadGroup : applicationContext.getBeansOfType(ContextLoadThreadGroup.class).values()) {
                contextLoadThreadGroup.join();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    @Nonnull
    protected ApplicationInformation generateApplicationInformationFor(@Nonnull ApplicationRequirement requirement) {
        ApplicationInformation original = (ApplicationInformation)this.getApplicationInformationGenerator().generate(ApplicationInformationRequirement.applicationInformationRequirementFor(requirement.getApplicationContextRequirement()));
        String requirementTitle = requirement.getTitle();
        ApplicationInformation result = !StringUtils.isEmpty((CharSequence)requirementTitle) ? new ApplicationInformationReImpl(original, requirementTitle) : original;
        return result;
    }

    @Nonnull
    protected LoggingEnvironment generateLoggingEnvironmentFor(@Nonnull ApplicationRequirement requirement) {
        return (LoggingEnvironment)this.getLoggingEnvironmentGenerator().generate((Requirement)requirement.getLoggingEnvironmentConfiguration());
    }

    @Nonnull
    public ApplicationContextGenerator getApplicationContextGenerator() {
        return this._applicationContextGenerator;
    }

    @Nonnull
    public ApplicationInformationGenerator getApplicationInformationGenerator() {
        return this._applicationInformationGenerator;
    }

    @Nonnull
    public LoggingEnvironmentGenerator getLoggingEnvironmentGenerator() {
        return this._loggingEnvironmentGenerator;
    }

    protected static class ApplicationInformationReImpl
    implements ApplicationInformation {
        @Nonnull
        private final ApplicationInformation _delegate;
        @Nonnull
        private final String _title;

        public ApplicationInformationReImpl(@Nonnull ApplicationInformation delegate, @Nonnull String title) {
            this._delegate = delegate;
            this._title = title;
        }

        @Override
        @Nullable
        public String getBanner() {
            return this._delegate.getBanner();
        }

        @Override
        @Nonnull
        public String getTitle() {
            return this._title;
        }

        @Override
        @Nullable
        public String getName() {
            return this._delegate.getName();
        }

        @Override
        @Nullable
        public String getVersion() {
            return this._delegate.getVersion();
        }

        @Override
        @Nullable
        public String getBuildRevision() {
            return this._delegate.getBuildRevision();
        }

        @Override
        @Nullable
        public String getBuildDate() {
            return this._delegate.getBuildDate();
        }
    }
}

