/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.echocat.jomon.spring.application.ApplicationContextGenerator;
import org.echocat.jomon.spring.application.ApplicationContextRequirement;
import org.echocat.jomon.spring.application.JavaBasedApplicationContextRequirement;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;

public class JavaBasedApplicationContextGenerator
implements ApplicationContextGenerator {
    @Override
    public boolean supports(@Nonnull ApplicationContextRequirement configuration) {
        return configuration instanceof JavaBasedApplicationContextRequirement;
    }

    @Nonnull
    public ConfigurableApplicationContext generate(@Nonnull ApplicationContextRequirement configuration) {
        if (configuration instanceof JavaBasedApplicationContextRequirement) {
            return this.generate((JavaBasedApplicationContextRequirement)configuration);
        }
        throw new IllegalArgumentException("Could not handle " + configuration + ".");
    }

    @Nonnull
    protected ConfigurableApplicationContext generate(@Nonnull JavaBasedApplicationContextRequirement configuration) {
        Collection<Class<?>> classes = configuration.getClasses();
        Impl result = new Impl();
        result.register(classes.toArray(new Class[classes.size()]));
        result.setParent(configuration.getParentApplicationContext());
        result.setClassLoader(configuration.getClassLoader());
        return result;
    }

    protected static class Impl
    extends GenericApplicationContext {
        @Nonnull
        private final AnnotatedBeanDefinitionReader _reader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)this);

        protected Impl() {
        }

        public void register(Class<?> ... annotatedClasses) {
            this._reader.register((Class[])annotatedClasses);
        }
    }
}

